/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.containers;

import com.folumo.isthisindustry.common.blockEntity.FirePlaceBlockEntity;
import com.folumo.isthisindustry.common.reg.ContainerReg;
import com.folumo.isthisindustry.common.reg.RecipeSerializerReg;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirePlaceContainer
extends AbstractContainerMenu {
    private Container container = new SimpleContainer(2);
    private FirePlaceBlockEntity be = null;
    public BlockPos pos = new BlockPos(0, 0, 0);
    public Level level;
    public SimpleContainerData containerData = new SimpleContainerData(2);

    public FirePlaceContainer(int i, Inventory playerInv, @NotNull RegistryFriendlyByteBuf buf) {
        this(i, playerInv, null, null);
        this.pos = buf.readBlockPos();
    }

    public FirePlaceContainer(int windowId, Inventory playerInv, @Nullable FirePlaceBlockEntity be, @Nullable SimpleContainerData data) {
        super((MenuType)ContainerReg.FIRE_PLACE.get(), windowId);
        this.level = playerInv.player.level();
        if (be != null) {
            this.be = be;
            this.containerData = data;
            this.container = this.be;
        }
        this.addSlot(new Slot(this.container, 0, 66, 84));
        this.addSlot(new Slot(this, this.container, 1, 156, 59){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                super.onTake(player, stack);
                this.container.setItem(0, ItemStack.EMPTY);
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInv, i1 + k * 9 + 9, 48 + i1 * 18, 129 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInv, l, 48 + l * 18, 187));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            if (index < 2) {
                if (!this.moveItemStackTo(stackInSlot, 2, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.isValidIngredient(stackInSlot)) {
                if (!this.moveItemStackTo(stackInSlot, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stackInSlot);
        }
        return itemstack;
    }

    private boolean isValidIngredient(ItemStack stack) {
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipeSerializerReg.FIRE_PLACE_TYPE.get(), (RecipeInput)CraftingInput.of((int)0, (int)0, Collections.singletonList(stack)), this.level);
        return recipe.isPresent();
    }

    public boolean stillValid(@NotNull Player player) {
        return this.container.stillValid(player);
    }
}

