/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.containers;

import com.folumo.isthisindustry.common.reg.ContainerReg;
import com.folumo.isthisindustry.common.reg.ItemReg;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MakeshiftPressContainer
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData containerData;

    public MakeshiftPressContainer(int windowId, Inventory playerInv) {
        this(windowId, playerInv, (Container)new SimpleContainer(4), new SimpleContainerData(2));
    }

    public MakeshiftPressContainer(int windowId, Inventory playerInv, Container simpleContainer, SimpleContainerData simpleContainerData) {
        super((MenuType)ContainerReg.MAKESHIFT_PRESS.get(), windowId);
        this.container = simpleContainer;
        this.containerData = simpleContainerData;
        this.addDataSlots((ContainerData)simpleContainerData);
        this.addSlot(new Slot(this, this.container, 0, 102, 52){

            @NotNull
            public ItemStack safeInsert(@NotNull ItemStack itemStack, int count) {
                if (itemStack.getItem() != ItemReg.TRANSISTOR.get()) {
                    return itemStack;
                }
                return super.safeInsert(itemStack, count);
            }
        });
        this.addSlot(new Slot(this, this.container, 1, 102, 75){

            @NotNull
            public ItemStack safeInsert(@NotNull ItemStack itemStack, int count) {
                if (itemStack.getItem() != ItemReg.SILICON.get()) {
                    return itemStack;
                }
                return super.safeInsert(itemStack, count);
            }
        });
        this.addSlot(new Slot(this, this.container, 2, 102, 98){

            @NotNull
            public ItemStack safeInsert(@NotNull ItemStack itemStack, int count) {
                if (itemStack.getItem() != ItemReg.COPPER_WIRE.get()) {
                    return itemStack;
                }
                return super.safeInsert(itemStack, count);
            }
        });
        this.addSlot(new Slot(this, this.container, 3, 156, 75){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInv, i1 + k * 9 + 9, 48 + i1 * 18, 129 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInv, l, 48 + l * 18, 187));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int i) {
        Slot slot = (Slot)this.slots.get(i);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slot.getItem();
        ItemStack itemstack = stackInSlot.copy();
        if (i == 3) {
            if (!this.moveItemStackTo(stackInSlot, 4, 40, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stackInSlot, itemstack);
        } else if (i >= 4) {
            if (stackInSlot.getItem() == ItemReg.TRANSISTOR.get()) {
                if (!this.moveItemStackTo(stackInSlot, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (stackInSlot.getItem() == ItemReg.SILICON.get()) {
                if (!this.moveItemStackTo(stackInSlot, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (stackInSlot.getItem() != ItemReg.COPPER_WIRE.get()) return ItemStack.EMPTY;
                if (!this.moveItemStackTo(stackInSlot, 2, 3, false)) {
                    return ItemStack.EMPTY;
                }
            }
        } else if (i >= 0 && !this.moveItemStackTo(stackInSlot, 4, 40, false)) {
            return ItemStack.EMPTY;
        }
        if (stackInSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stackInSlot.getCount() == itemstack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stackInSlot);
        return itemstack;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public float getProgress() {
        int i = this.containerData.get(0);
        int j = this.containerData.get(1);
        return i != 0 && j != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }
}

