/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.containers;

import com.folumo.isthisindustry.common.reg.ContainerReg;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ResearchStationContainer
extends AbstractContainerMenu {
    public final Player player;

    public ResearchStationContainer(int windowId, Inventory playerInv) {
        super((MenuType)ContainerReg.RESEARCH_STATION.get(), windowId);
        this.player = playerInv.player;
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInv, i1 + k * 9 + 9, 48 + i1 * 18, 129 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInv, l, 48 + l * 18, 187));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int i) {
        Slot slot = (Slot)this.slots.get(i);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slot.getItem();
        ItemStack itemstack = stackInSlot.copy();
        if (stackInSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stackInSlot.getCount() == itemstack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stackInSlot);
        return itemstack;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

