/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.items;

import com.folumo.isthisindustry.common.blockEntity.HologramBlockEntity;
import com.folumo.isthisindustry.common.containers.BlueprintContainer;
import com.folumo.isthisindustry.common.inerfaces.IBlueprint;
import com.folumo.isthisindustry.common.reg.BlockEntityReg;
import com.folumo.isthisindustry.common.reg.ComponentsReg;
import com.folumo.tomatolib.common.item.ExtendedItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BlueprintItem
extends ExtendedItem {
    public BlueprintItem(Item.Properties props) {
        super(props.stacksTo(1));
    }

    public static void setBlueprintType(ItemStack stack, ResourceLocation type) {
        stack.set(ComponentsReg.BLUEPRINT_TYPE, (Object)type);
    }

    public static ResourceLocation getBlueprintType(ItemStack stack) {
        return (ResourceLocation)stack.get(ComponentsReg.BLUEPRINT_TYPE);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, components, tooltipFlag);
        if (stack.has(ComponentsReg.BLUEPRINT_TYPE)) {
            ResourceLocation tag = (ResourceLocation)stack.get(ComponentsReg.BLUEPRINT_TYPE);
            assert (tag != null);
            MutableComponent name = Component.translatable((String)("block." + tag.getNamespace() + "." + tag.getPath()));
            components.add((Component)Component.translatable((String)"error.isthisindustry.blueprint.type_set").append((Component)name));
        } else {
            components.add((Component)Component.translatable((String)"error.isthisindustry.blueprint.no_type"));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu(new MenuProvider(this){

                @NotNull
                public Component getDisplayName() {
                    return Component.translatable((String)"container.isthisindustry.blueprint");
                }

                public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
                    return new BlueprintContainer(windowId, playerInventory);
                }
            });
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos clickedPosOriginal = context.getClickedPos();
        BlockPos clickedPos = context.getClickedPos().relative(context.getClickedFace());
        ItemStack stack = context.getItemInHand();
        if (!level.isClientSide && player instanceof ServerPlayer && player.isShiftKeyDown()) {
            BlockEntity blockEntity = level.getBlockEntity(clickedPosOriginal);
            if (blockEntity instanceof HologramBlockEntity) {
                HologramBlockEntity hologramBlockEntity = (HologramBlockEntity)blockEntity;
                String targetedBlock = hologramBlockEntity.getTargetBlock();
                BlockPos blockPos = hologramBlockEntity.getOriginBlockPos();
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)targetedBlock));
                if (block instanceof IBlueprint) {
                    IBlueprint blueprintBlock = (IBlueprint)block;
                    List<BlockPos> blueprintPos = blueprintBlock.getBlueprintSize(blockPos);
                    blueprintPos.forEach(blockPosTarget -> level.removeBlock(blockPosTarget, false));
                }
                return InteractionResult.SUCCESS;
            }
            ResourceLocation target = BlueprintItem.getBlueprintType(stack);
            Block block = (Block)BuiltInRegistries.BLOCK.get(target);
            if (block instanceof IBlueprint) {
                IBlueprint blueprintBlock = (IBlueprint)block;
                if (blueprintBlock.canPlace(level, clickedPos)) {
                    List<BlockPos> blueprintSize = blueprintBlock.getBlueprintSize(clickedPos);
                    for (BlockPos pos : blueprintSize) {
                        level.setBlock(pos, ((Block)BlockEntityReg.HOLOGRAM.blockData.block.get()).defaultBlockState(), 3);
                        BlockEntity toSetData = level.getBlockEntity(pos);
                        if (!(toSetData instanceof HologramBlockEntity)) continue;
                        HologramBlockEntity hologramBlockEntity = (HologramBlockEntity)toSetData;
                        hologramBlockEntity.setData(clickedPos, target.toString());
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"error.isthisindustry.blueprint.no_space"), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }
}

