/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.misc.transporters;

import com.folumo.isthisindustry.common.blockEntity.ElectricBE;
import com.folumo.isthisindustry.common.blocks.transporters.CableBlock;
import com.folumo.isthisindustry.common.blocks.transporters.ConsumerBlock;
import com.folumo.isthisindustry.common.blocks.transporters.ProviderBlock;
import com.folumo.isthisindustry.common.misc.transporters.CableNetworkStorage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CableNetworkManager {
    private static final List<CableNetwork> networks = new ArrayList<CableNetwork>();

    public static void rebuildNetwork(Level level, BlockPos start) {
        if (level.isClientSide) {
            return;
        }
        Set<BlockPos> foundCables = CableNetworkManager.walkConnectedCables(level, start);
        if (foundCables.isEmpty()) {
            return;
        }
        HashSet<CableNetwork> overlappingNetworks = new HashSet<CableNetwork>();
        for (BlockPos pos2 : foundCables) {
            CableNetwork existing = CableNetworkManager.getNetworkContaining(pos2);
            if (existing == null) continue;
            overlappingNetworks.add(existing);
        }
        networks.removeAll(overlappingNetworks);
        HashSet<BlockPos> allCables = new HashSet<BlockPos>(foundCables);
        HashSet<BlockPos> allProviders = new HashSet<BlockPos>();
        HashSet<BlockPos> allConsumers = new HashSet<BlockPos>();
        for (CableNetwork net : overlappingNetworks) {
            allCables.addAll(net.cables);
            allProviders.addAll(net.providers);
            allConsumers.addAll(net.consumers);
        }
        for (BlockPos cablePos : new HashSet<BlockPos>(allCables)) {
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = cablePos.relative(dir);
                Block nbBlock = level.getBlockState(neighbor).getBlock();
                if (nbBlock instanceof ProviderBlock) {
                    allProviders.add(neighbor);
                    continue;
                }
                if (!(nbBlock instanceof ConsumerBlock)) continue;
                allConsumers.add(neighbor);
            }
        }
        allCables.removeIf(pos -> !(level.getBlockState(pos).getBlock() instanceof CableBlock));
        allProviders.removeIf(pos -> !(level.getBlockState(pos).getBlock() instanceof ProviderBlock));
        allConsumers.removeIf(pos -> !(level.getBlockState(pos).getBlock() instanceof ConsumerBlock));
        if (!(allCables.isEmpty() && allProviders.isEmpty() && allConsumers.isEmpty())) {
            CableNetwork newNetwork = new CableNetwork();
            newNetwork.cables.addAll(allCables);
            newNetwork.providers.addAll(allProviders);
            newNetwork.consumers.addAll(allConsumers);
            networks.add(newNetwork);
        }
    }

    public static Set<BlockPos> walkConnectedCables(Level level, BlockPos start) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        if (!level.isLoaded(start)) {
            return Collections.emptySet();
        }
        Block startBlock = level.getBlockState(start).getBlock();
        if (!(startBlock instanceof CableBlock || startBlock instanceof ProviderBlock || startBlock instanceof ConsumerBlock)) {
            return Collections.emptySet();
        }
        queue.add(start);
        while (!queue.isEmpty()) {
            Block block;
            BlockPos current = (BlockPos)queue.poll();
            if (!visited.add(current) || !((block = level.getBlockState(current).getBlock()) instanceof CableBlock) && !(block instanceof ProviderBlock) && !(block instanceof ConsumerBlock)) continue;
            for (Direction dir : Direction.values()) {
                Block nbBlock;
                BlockPos neighbor = current.relative(dir);
                if (visited.contains(neighbor) || !level.isLoaded(neighbor) || !((nbBlock = level.getBlockState(neighbor).getBlock()) instanceof CableBlock) && !(nbBlock instanceof ProviderBlock) && !(nbBlock instanceof ConsumerBlock)) continue;
                queue.add(neighbor);
            }
        }
        return visited;
    }

    @Nullable
    private static CableNetwork getNetworkContaining(BlockPos pos) {
        for (CableNetwork network : networks) {
            if (!network.contains(pos)) continue;
            return network;
        }
        return null;
    }

    private static void dfs(Level level, BlockPos pos, Set<BlockPos> visited, CableNetwork net) {
        if (!level.isLoaded(pos)) {
            return;
        }
        if (visited.contains(pos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof CableBlock) {
            visited.add(pos);
            net.cables.add(pos);
        } else if (block instanceof ProviderBlock) {
            visited.add(pos);
            net.providers.add(pos);
        } else if (block instanceof ConsumerBlock) {
            visited.add(pos);
            net.consumers.add(pos);
        } else {
            return;
        }
        for (Direction dir : Direction.values()) {
            Block nbBlock;
            BlockPos neighbor = pos.relative(dir);
            if (visited.contains(neighbor) || !level.isLoaded(neighbor) || !((nbBlock = level.getBlockState(neighbor).getBlock()) instanceof CableBlock) && !(nbBlock instanceof ProviderBlock) && !(nbBlock instanceof ConsumerBlock)) continue;
            CableNetworkManager.dfs(level, neighbor, visited, net);
        }
    }

    public static void onBlockPlaced(Level level, BlockPos pos) {
        CableNetworkManager.rebuildNetwork(level, pos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CableNetworkStorage.get(serverLevel).setNetworks(networks);
        }
    }

    public static void onBlockRemoved(Level level, BlockPos pos) {
        if (level.isClientSide) {
            return;
        }
        CableNetwork affected = null;
        for (CableNetwork cableNetwork : networks) {
            if (!cableNetwork.contains(pos)) continue;
            affected = cableNetwork;
            break;
        }
        if (affected == null) {
            return;
        }
        networks.remove(affected);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            Block nbBlock;
            BlockPos neighbor = pos.relative(dir);
            if (visited.contains(neighbor) || !level.isLoaded(neighbor) || !((nbBlock = level.getBlockState(neighbor).getBlock()) instanceof CableBlock) && !(nbBlock instanceof ProviderBlock) && !(nbBlock instanceof ConsumerBlock)) continue;
            CableNetwork subNet = new CableNetwork();
            CableNetworkManager.dfs(level, neighbor, visited, subNet);
            if (!subNet.isValid(level)) continue;
            networks.add(subNet);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CableNetworkStorage.get(serverLevel).setNetworks(networks);
        }
    }

    public static List<CableNetwork> getNetworks() {
        return networks;
    }

    public static void tick(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        networks.removeIf(net -> !net.isValid(level));
        for (CableNetwork net2 : networks) {
            net2.tick((Level)serverLevel);
        }
        CableNetworkStorage storage = CableNetworkStorage.get(serverLevel);
        storage.setNetworks(networks);
    }

    public static class CableNetwork {
        public final Set<BlockPos> cables = new HashSet<BlockPos>();
        public final Set<BlockPos> providers = new HashSet<BlockPos>();
        public final Set<BlockPos> consumers = new HashSet<BlockPos>();

        public boolean isStillPresent(Level level) {
            return Stream.concat(Stream.concat(this.cables.stream(), this.providers.stream()), this.consumers.stream()).anyMatch(pos -> {
                Block b = level.getBlockState(pos).getBlock();
                return b instanceof CableBlock || b instanceof ProviderBlock || b instanceof ConsumerBlock;
            });
        }

        public boolean isValid(Level level) {
            return this.isStillPresent(level) && (!this.cables.isEmpty() || !this.providers.isEmpty() || !this.consumers.isEmpty());
        }

        public boolean contains(BlockPos pos) {
            return this.cables.contains(pos) || this.providers.contains(pos) || this.consumers.contains(pos);
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.putLongArray("cables", this.cables.stream().mapToLong(BlockPos::asLong).toArray());
            tag.putLongArray("providers", this.providers.stream().mapToLong(BlockPos::asLong).toArray());
            tag.putLongArray("consumers", this.consumers.stream().mapToLong(BlockPos::asLong).toArray());
            return tag;
        }

        public static CableNetwork fromNBT(CompoundTag tag) {
            CableNetwork net = new CableNetwork();
            Arrays.stream(tag.getLongArray("cables")).forEach(l -> net.cables.add(BlockPos.of((long)l)));
            Arrays.stream(tag.getLongArray("providers")).forEach(l -> net.providers.add(BlockPos.of((long)l)));
            Arrays.stream(tag.getLongArray("consumers")).forEach(l -> net.consumers.add(BlockPos.of((long)l)));
            return net;
        }

        public void forEachProvider(Level level, Consumer<ElectricBE> consumer) {
            for (BlockPos blockPos : new HashSet<BlockPos>(this.providers)) {
                ElectricBE electric;
                BlockEntity be = level.getBlockEntity(blockPos);
                if (!(be instanceof ElectricBE) || !(electric = (ElectricBE)be).canExtract()) continue;
                consumer.accept(electric);
            }
        }

        public void forEachConsumer(Level level, Consumer<ElectricBE> consumer) {
            for (BlockPos blockPos : new HashSet<BlockPos>(this.consumers)) {
                ElectricBE electric;
                BlockEntity be = level.getBlockEntity(blockPos);
                if (!(be instanceof ElectricBE) || !(electric = (ElectricBE)be).canReceive()) continue;
                consumer.accept(electric);
            }
        }

        public void tick(Level level) {
            AtomicInteger networkEnergy = new AtomicInteger();
            AtomicInteger networkEnergyNeeded = new AtomicInteger();
            this.forEachProvider(level, electricBE -> networkEnergy.addAndGet(electricBE.getEnergyStored()));
            this.forEachConsumer(level, electricBE -> networkEnergyNeeded.addAndGet(electricBE.getMaxEnergyStored() - electricBE.getEnergyStored()));
            System.out.println(networkEnergy.get());
            System.out.println(networkEnergyNeeded.get());
            if (networkEnergy.get() > networkEnergyNeeded.get()) {
                this.forEachConsumer(level, electricBE -> electricBE.setEnergy(electricBE.getMaxEnergyStored()));
                this.forEachProvider(level, electricBE -> {
                    int networkEnNeeded;
                    int energyAmount = electricBE.getEnergyStored();
                    if (energyAmount > (networkEnNeeded = networkEnergyNeeded.get())) {
                        electricBE.extractEnergy(networkEnNeeded, false);
                        networkEnergyNeeded.set(0);
                    } else if (energyAmount == networkEnNeeded) {
                        electricBE.setEnergy(0);
                        networkEnergyNeeded.set(0);
                    } else {
                        electricBE.setEnergy(0);
                        networkEnergyNeeded.getAndAdd(-energyAmount);
                    }
                });
            } else if (networkEnergy.get() == networkEnergyNeeded.get()) {
                this.forEachConsumer(level, electricBE -> electricBE.setEnergy(electricBE.getMaxEnergyStored()));
                this.forEachProvider(level, electricBE -> electricBE.setEnergy(0));
            } else {
                this.forEachConsumer(level, electricBE -> {
                    int networkEn;
                    int energyNeeded = electricBE.getMaxEnergyStored() - electricBE.getEnergyStored();
                    if (energyNeeded > (networkEn = networkEnergy.get())) {
                        electricBE.receiveEnergy(networkEn, false);
                        networkEnergy.set(0);
                    } else if (energyNeeded == networkEn) {
                        electricBE.setEnergy(electricBE.getMaxEnergyStored());
                        networkEnergy.set(0);
                    } else {
                        electricBE.setEnergy(electricBE.getMaxEnergyStored());
                        networkEnergy.addAndGet(-energyNeeded);
                    }
                });
                this.forEachProvider(level, electricBE -> electricBE.setEnergy(0));
            }
        }

        public boolean overlapsWith(CableNetwork other) {
            for (BlockPos pos : other.cables) {
                if (!this.cables.contains(pos)) continue;
                return true;
            }
            return false;
        }
    }
}

