/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.misc.transporters;

import com.folumo.isthisindustry.common.misc.transporters.CableNetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class CableNetworkStorage
extends SavedData {
    private final List<CableNetworkManager.CableNetwork> networks = new ArrayList<CableNetworkManager.CableNetwork>();
    public static final String NAME = "cable_networks";

    public static CableNetworkStorage get(ServerLevel level) {
        return (CableNetworkStorage)level.getDataStorage().computeIfAbsent(new SavedData.Factory(CableNetworkStorage::new, CableNetworkStorage::load, DataFixTypes.LEVEL), NAME);
    }

    private CableNetworkStorage() {
    }

    private static CableNetworkStorage load(CompoundTag tag, HolderLookup.Provider provider) {
        CableNetworkStorage storage = new CableNetworkStorage();
        ListTag list = tag.getList("networks", 10);
        for (Tag entry : list) {
            CompoundTag netTag = (CompoundTag)entry;
            CableNetworkManager.CableNetwork net = CableNetworkManager.CableNetwork.fromNBT(netTag);
            storage.networks.add(net);
        }
        return storage;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (CableNetworkManager.CableNetwork net : this.networks) {
            list.add((Object)net.toNBT());
        }
        tag.put("networks", (Tag)list);
        return tag;
    }

    public List<CableNetworkManager.CableNetwork> getNetworks() {
        return this.networks;
    }

    public void setNetworks(List<CableNetworkManager.CableNetwork> newNetworks) {
        this.networks.clear();
        this.networks.addAll(newNetworks);
        this.setDirty();
        System.out.println("Will be saved, i hope..");
    }
}

