/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.payload.advancement;

import com.folumo.isthisindustry.common.misc.research.Research;
import com.folumo.isthisindustry.common.misc.research.ResourceLocationIntPair;
import com.folumo.isthisindustry.common.network.RequestGrantAdvancementPayload;
import com.folumo.isthisindustry.common.reg.ResearchReg;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler_advancement {
    private static boolean isSameItem(Item item, ResourceLocation location) {
        return BuiltInRegistries.ITEM.getKey((Object)item).equals((Object)location);
    }

    public static void handleRequest(RequestGrantAdvancementPayload payload, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        ResourceLocation id = ResourceLocation.parse((String)payload.advancement());
        Research research = ResearchReg.get(id);
        if (research == null) {
            return;
        }
        for (ResourceLocationIntPair cost : research.cost()) {
            int count = 0;
            for (ItemStack stack : player.getInventory().items) {
                if (!ServerPayloadHandler_advancement.isSameItem(stack.getItem(), cost.resourceLocation())) continue;
                count += stack.getCount();
            }
            if (count >= cost.num()) continue;
            return;
        }
        block2: for (ResourceLocationIntPair cost : research.cost()) {
            int toRemove = cost.num();
            for (ItemStack stack : player.getInventory().items) {
                if (!ServerPayloadHandler_advancement.isSameItem(stack.getItem(), cost.resourceLocation())) continue;
                int removed = Math.min(stack.getCount(), toRemove);
                stack.shrink(removed);
                if ((toRemove -= removed) > 0) continue;
                continue block2;
            }
        }
        context.enqueueWork(() -> {
            AdvancementProgress progress;
            AdvancementHolder advancement = player.server.getAdvancements().get(id);
            if (advancement != null && !(progress = player.getAdvancements().getOrStartProgress(advancement)).isDone()) {
                for (String criterion : progress.getRemainingCriteria()) {
                    player.getAdvancements().award(advancement, criterion);
                }
            }
        });
    }
}

