/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.payload.hologram;

import com.folumo.isthisindustry.common.blockEntity.HologramBlockEntity;
import com.folumo.isthisindustry.common.inerfaces.IBlueprint;
import com.folumo.isthisindustry.common.network.RequestBuildHologramPayload;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler_hologram {
    public static void handleRequest(RequestBuildHologramPayload payload, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        BlockPos origin = payload.origin();
        Level level = player.level();
        BlockEntity be = level.getBlockEntity(origin);
        HologramBlockEntity hologramBlockEntity = (HologramBlockEntity)be;
        assert (hologramBlockEntity != null);
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)hologramBlockEntity.getTargetBlock()));
        IBlueprint blueprint = (IBlueprint)block;
        for (ItemStack cost : blueprint.blueprintCost()) {
            int count = 0;
            for (ItemStack stack : player.getInventory().items) {
                if (!stack.getItem().equals(cost.getItem())) continue;
                count += stack.getCount();
            }
            if (count >= cost.getCount()) continue;
            return;
        }
        block2: for (ItemStack cost : blueprint.blueprintCost()) {
            int toRemove = cost.getCount();
            for (ItemStack stack : player.getInventory().items) {
                if (!stack.getItem().equals(cost.getItem())) continue;
                int removed = Math.min(stack.getCount(), toRemove);
                stack.shrink(removed);
                if ((toRemove -= removed) > 0) continue;
                continue block2;
            }
        }
        context.enqueueWork(() -> {
            IBlueprint blueprintBlock = (IBlueprint)block;
            List<BlockPos> blueprintPos = blueprintBlock.getBlueprintSize(origin);
            blueprintPos.forEach(blockPosTarget -> level.removeBlock(blockPosTarget, false));
            BlockState blockState = block.defaultBlockState();
            level.setBlock(origin, blockState, 3);
            player.closeContainer();
        });
    }
}

