/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.recipes;

import com.folumo.isthisindustry.common.reg.RecipeSerializerReg;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FirePlaceRecipe
implements CraftingRecipe {
    private final ItemStack result;
    private final String group;
    private final Ingredient input;

    public FirePlaceRecipe(String group, ItemStack result, Ingredient input) {
        this.result = result;
        this.group = group;
        this.input = input;
    }

    public boolean matches(CraftingInput craftingInput, @NotNull Level level) {
        if (craftingInput.ingredientCount() != 1) {
            return false;
        }
        return craftingInput.size() == 1 ? this.input.test(craftingInput.getItem(0)) : craftingInput.stackedContents().canCraft((Recipe)this, null);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput p_345149_, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_346030_) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y == 1;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_336125_) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializerReg.FIRE_PLACE.get();
    }

    @NotNull
    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public static class Serializer
    implements RecipeSerializer<FirePlaceRecipe> {
        public static final MapCodec<FirePlaceRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(FirePlaceRecipe::getInput)).apply((Applicative)builder, FirePlaceRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FirePlaceRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<FirePlaceRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FirePlaceRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FirePlaceRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf(Short.MAX_VALUE);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return new FirePlaceRecipe(group, result, input);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FirePlaceRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
        }
    }

    public static class Type
    implements RecipeType<FirePlaceRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return "isthisindustry:fire_place";
        }
    }
}

