/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.isthisindustry.common.recipes;

import com.folumo.isthisindustry.common.reg.RecipeSerializerReg;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;

public class ShapelessDamagingRecipe
extends ShapelessRecipe {
    private final ItemStack result;

    public ShapelessDamagingRecipe(String group, ItemStack result, NonNullList<Ingredient> inputs) {
        super(group, CraftingBookCategory.MISC, result, inputs);
        this.result = result;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput inventory) {
        NonNullList remaining = super.getRemainingItems((RecipeInput)inventory);
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!(stack.getItem() instanceof ShearsItem)) continue;
            ItemStack shears = stack.copy();
            if (shears.isDamageableItem()) {
                int damage = shears.getDamageValue() + 1;
                shears.setDamageValue(damage);
                if (damage >= shears.getMaxDamage()) continue;
                remaining.set(i, (Object)shears);
                continue;
            }
            remaining.set(i, (Object)shears);
        }
        return remaining;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializerReg.CRAFTING_DMG.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessDamagingRecipe> {
        public static final MapCodec<ShapelessDamagingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(field -> {
            Object[] ingredients = (Ingredient[])field.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)builder, ShapelessDamagingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessDamagingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<ShapelessDamagingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessDamagingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessDamagingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf(Short.MAX_VALUE);
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            inputs.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new ShapelessDamagingRecipe(group, result, (NonNullList<Ingredient>)inputs);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapelessDamagingRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

