/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.nanhealthfixerneo;

import com.wintercogs.nanhealthfixerneo.Config;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="nanhealthfixerneo")
public class NaNHealthFixerNeo {
    public static final String MODID = "nanhealthfixerneo";

    public NaNHealthFixerNeo(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        IEventBus gameBus = NeoForge.EVENT_BUS;
        gameBus.addListener(this::onDeath);
        gameBus.addListener(this::onEntityTick);
        gameBus.addListener(this::onIncomingDamage);
        gameBus.addListener(this::onDamagePost);
    }

    private void onDeath(LivingDeathEvent event) {
        NaNHealthFixerNeo.validateHealth(event.getEntity());
    }

    private void onEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            NaNHealthFixerNeo.validateHealth(living);
        }
    }

    private void onIncomingDamage(LivingIncomingDamageEvent event) {
        DamageContainer container = event.getContainer();
        if (Float.isNaN(container.getNewDamage())) {
            event.setCanceled(true);
        }
    }

    private void onDamagePost(LivingDamageEvent.Post event) {
        NaNHealthFixerNeo.validateHealth(event.getEntity());
    }

    private static void validateHealth(@NotNull LivingEntity entity) {
        if (entity.level().isClientSide) {
            return;
        }
        float health = entity.getHealth();
        if (Float.isNaN(health) || health < 0.0f) {
            entity.setHealth(0.0f);
        }
    }
}

