/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import io.github.niestrat99.advancedteleport.config.CustomMessages;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class ATSign {
    @NotNull
    private final String requiredPermission;
    @NotNull
    private final String adminPermission;
    @NotNull
    private final String name;
    @NotNull
    private final Component displayName;
    private final boolean enabled;

    @Contract(pure=true)
    protected ATSign(@NotNull String name, boolean enabled) {
        this.requiredPermission = ("at.member." + name + ".use-sign").toLowerCase();
        this.adminPermission = ("at.admin.sign." + name + ".create").toLowerCase();
        this.displayName = CustomMessages.getComponent("Signs." + name.toLowerCase(), new TagResolver[0]);
        this.name = name;
        this.enabled = enabled;
    }

    public abstract void onInteract(@NotNull Sign var1, @NotNull Player var2);

    public abstract boolean canCreate(@NotNull List<Component> var1, @NotNull Player var2);

    public boolean canCreate(@NotNull String[] lines, @NotNull Player player) {
        ArrayList<Component> components = new ArrayList<Component>(lines.length);
        for (String line : lines) {
            components.add((Component)Component.text((String)line));
        }
        return this.canCreate(components, player);
    }

    @Contract(pure=true)
    public boolean isEnabled() {
        return this.enabled;
    }

    @Contract(pure=true)
    @NotNull
    public String getAdminPermission() {
        return this.adminPermission;
    }

    @Contract(pure=true)
    @NotNull
    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    @Contract(pure=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Contract(pure=true)
    @NotNull
    public Component getDisplayName() {
        return this.displayName;
    }
}

