/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockInfo {
    @NotNull
    private final UUID receiverUUID;
    @NotNull
    private final UUID blockedUUID;
    @NotNull
    private final String formattedTime;
    private final long time;
    @Nullable
    private String reason;

    @Contract(pure=true)
    public BlockInfo(@NotNull UUID receiver, @NotNull UUID blocked, @Nullable String reason, long time) {
        this.receiverUUID = receiver;
        this.blockedUUID = blocked;
        this.reason = reason;
        this.time = time;
        Date date = new Date(time);
        SimpleDateFormat format = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
        this.formattedTime = format.format(date);
    }

    @Contract(pure=true)
    @NotNull
    public OfflinePlayer getReceivingPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.receiverUUID);
    }

    @Contract(pure=true)
    @NotNull
    public OfflinePlayer getBlockedPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.blockedUUID);
    }

    @Contract(pure=true)
    @NotNull
    public UUID getReceiverUUID() {
        return this.receiverUUID;
    }

    @Contract(pure=true)
    public long getTime() {
        return this.time;
    }

    @Contract(pure=true)
    @NotNull
    public UUID getBlockedUUID() {
        return this.blockedUUID;
    }

    @Contract(pure=true)
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Contract(pure=true)
    public void setReason(@Nullable String reason) {
        this.reason = reason;
    }

    @Contract(pure=true)
    @NotNull
    public String getFormattedTime() {
        return this.formattedTime;
    }
}

