/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.NamedLocation;
import io.github.niestrat99.advancedteleport.api.WorldlessLocation;
import io.github.niestrat99.advancedteleport.api.events.homes.HomeMoveEvent;
import io.github.niestrat99.advancedteleport.sql.HomeSQLManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Home
implements NamedLocation {
    @NotNull
    private final UUID owner;
    @NotNull
    private final String name;
    @NotNull
    private final String createdTimeFormatted;
    @NotNull
    private final SimpleDateFormat format;
    private final long createdTime;
    @NotNull
    private String updatedTimeFormatted;
    @NotNull
    private Location location;
    private long updatedTime;

    @Contract(pure=true)
    public Home(@NotNull UUID owner, @NotNull String name, @NotNull Location location, long createdTime, long updatedTime) {
        this.name = name;
        this.owner = owner;
        this.location = location instanceof WorldlessLocation ? location : new WorldlessLocation(location, location.getWorld().getName());
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
        this.format = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
        this.createdTimeFormatted = this.format.format(new Date(createdTime));
        this.updatedTimeFormatted = this.format.format(new Date(updatedTime));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Contract(pure=true)
    @NotNull
    public UUID getOwner() {
        return this.owner;
    }

    @NotNull
    public CompletableFuture<Void> move(@NotNull Location location, @Nullable CommandSender sender) {
        return AdvancedTeleportAPI.validateEvent(new HomeMoveEvent(this, location, sender), event -> {
            this.location = event.getLocation();
            this.updatedTime = System.currentTimeMillis();
            this.updatedTimeFormatted = this.format.format(new Date(this.updatedTime));
            HomeSQLManager.get().moveHome(location, this.owner, this.name, false);
            return null;
        });
    }

    @Contract(pure=true)
    public long getUpdatedTime() {
        return this.updatedTime;
    }

    @Contract(pure=true)
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Contract(pure=true)
    @NotNull
    public String getCreatedTimeFormatted() {
        return this.createdTimeFormatted;
    }

    @Contract(pure=true)
    @NotNull
    public String getUpdatedTimeFormatted() {
        return this.updatedTimeFormatted;
    }
}

