/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import io.github.niestrat99.advancedteleport.api.TeleportRequestType;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TeleportRequest(@NotNull Player requester, @NotNull Player responder, @NotNull BukkitRunnable timer, @NotNull TeleportRequestType type) {
    private static final List<TeleportRequest> requestList = new ArrayList<TeleportRequest>();

    @Contract(pure=true)
    @NotNull
    public static List<TeleportRequest> getRequestsByRequester(@NotNull Player requester) {
        return requestList.stream().filter(request -> request.requester().equals(requester)).toList();
    }

    @Contract(pure=true)
    @Nullable
    public static TeleportRequest getRequestByReqAndResponder(@NotNull Player responder, @NotNull Player requester) {
        return requestList.stream().filter(request -> request.responder().equals(responder)).filter(request -> request.requester().equals(requester)).findFirst().orElse(null);
    }

    @Contract(pure=true)
    public static void addRequest(@NotNull TeleportRequest request) {
        if (MainConfig.get().USE_MULTIPLE_REQUESTS.get().booleanValue()) {
            requestList.add(request);
            return;
        }
        Boolean shouldNotify = MainConfig.get().NOTIFY_ON_EXPIRE.get();
        TeleportRequest.getRequests(request.responder()).forEach(otherRequest -> {
            otherRequest.destroy();
            if (!shouldNotify.booleanValue()) {
                return;
            }
            CustomMessages.sendMessage((CommandSender)otherRequest.requester(), "Error.requestDisplaced", new TagResolver[]{Placeholder.unparsed((String)"player", (String)otherRequest.responder().getName())});
        });
        requestList.add(request);
    }

    @Contract(pure=true)
    @NotNull
    public static List<TeleportRequest> getRequests(@NotNull Player responder) {
        return requestList.stream().filter(request -> request.responder().equals(responder)).toList();
    }

    @Contract(pure=true)
    public void destroy() {
        this.timer.cancel();
        TeleportRequest.removeRequest(this);
    }

    @Contract(pure=true)
    public static void removeRequest(@NotNull TeleportRequest request) {
        requestList.remove(request);
    }
}

