/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldlessLocation
extends Location {
    @NotNull
    private String worldName;

    public WorldlessLocation(@NotNull Location location, @NotNull String worldName) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.worldName = worldName;
    }

    public WorldlessLocation(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, yaw, pitch);
        this.worldName = world.getName();
    }

    public WorldlessLocation(@NotNull String worldName, double x, double y, double z, float yaw, float pitch) {
        super(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
        this.worldName = worldName;
    }

    public World getWorld() {
        if (super.getWorld() != null) {
            return super.getWorld();
        }
        return Bukkit.getWorld((String)this.worldName);
    }

    public void setWorld(@Nullable World world) {
        if (world == null) {
            return;
        }
        this.worldName = world.getName();
    }
}

