/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.data;

import io.github.niestrat99.advancedteleport.api.data.CancelledEventException;
import io.github.niestrat99.advancedteleport.api.data.UnloadedWorldException;
import java.util.concurrent.CompletableFuture;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ATException
extends Exception {
    @Nullable
    private final transient CommandSender sender;

    @Contract(pure=true)
    protected ATException(@Nullable String message) {
        this(null, message);
    }

    @Contract(pure=true)
    protected ATException(@Nullable CommandSender sender, @Nullable String message) {
        super("Context [%s] | Message [%s]".formatted(sender == null ? "null" : sender.getName(), message));
        this.sender = sender;
    }

    @Contract(pure=true)
    protected ATException(@Nullable CommandSender sender) {
        this(sender, null);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> CompletableFuture<T> failedFuture(Cancellable event) {
        return CancelledEventException.of(event).future();
    }

    @Contract(pure=true)
    @NotNull
    public <T> CompletableFuture<T> future() {
        return CompletableFuture.failedFuture(this);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T> CompletableFuture<T> failedFuture(@Nullable CommandSender sender, @NotNull String message) {
        return ATException.failed(sender, message).future();
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ATException failed(@Nullable CommandSender sender, @NotNull String message) {
        return new ATException(sender, message);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> CompletableFuture<T> failedFuture(@NotNull String message) {
        return new ATException(message).future();
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T> CompletableFuture<T> failedFuture(@NotNull World world, @NotNull String message) {
        return new UnloadedWorldException(world, message).future();
    }

    @Contract(pure=true)
    @Nullable
    public CommandSender sender() {
        return this.sender;
    }
}

