/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.events.homes;

import io.github.niestrat99.advancedteleport.api.events.TrackableATEvent;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HomeCreateEvent
extends TrackableATEvent {
    private static final HandlerList handlers = new HandlerList();
    @NotNull
    private OfflinePlayer player;
    @NotNull
    private String name;
    @NotNull
    private Location location;

    @Contract(pure=true)
    public HomeCreateEvent(@NotNull OfflinePlayer player, @NotNull String name, @NotNull Location location, @Nullable Player creator) throws IllegalArgumentException, IllegalStateException {
        super((CommandSender)creator);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The home name must not be empty.");
        }
        if (!location.isWorldLoaded()) {
            throw new IllegalStateException("The location's world is not loaded.");
        }
        this.player = player;
        this.name = name;
        this.location = location;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Contract(pure=true)
    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Contract(pure=true)
    @NotNull
    public OfflinePlayer getPlayer() {
        return this.player;
    }

    @Contract(pure=true)
    public void setPlayer(@NotNull OfflinePlayer player) {
        this.player = player;
    }

    @Contract(pure=true)
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Contract(pure=true)
    public void setLocation(@NotNull Location location) throws IllegalStateException {
        if (!location.isWorldLoaded()) {
            throw new IllegalStateException("The location's world is not loaded.");
        }
        this.location = location;
    }

    @Contract(pure=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Contract(pure=true)
    public void setName(@NotNull String name) throws IllegalArgumentException {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The home name must not be empty.");
        }
        this.name = name;
    }
}

