/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.api.events.spawn;

import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.events.TrackableATEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpawnMirrorEvent
extends TrackableATEvent {
    private static final HandlerList handlers = new HandlerList();
    @NotNull
    private Spawn fromSpawn;
    @Nullable
    private Spawn toSpawn;

    @Contract(pure=true)
    public SpawnMirrorEvent(@NotNull Spawn fromSpawn, @Nullable Spawn toSpawn, @Nullable CommandSender sender) throws IllegalArgumentException {
        super(sender);
        this.fromSpawn = fromSpawn;
        this.toSpawn = toSpawn;
    }

    @Contract(pure=true)
    @NotNull
    public Spawn getSourceSpawn() {
        return this.fromSpawn;
    }

    @Contract(pure=true)
    @Nullable
    public Spawn getDestinationSpawn() {
        return this.toSpawn;
    }

    @Contract(pure=true)
    public void setFromSpawn(@NotNull Spawn fromSpawn) throws IllegalArgumentException {
        this.fromSpawn = fromSpawn;
    }

    @Contract(pure=true)
    public void setDestinationSpawn(@NotNull Spawn toSpawn) throws IllegalArgumentException {
        if (toSpawn == this.fromSpawn) {
            throw new IllegalArgumentException("The source spawn and destination spawn must differ!");
        }
        this.toSpawn = toSpawn;
    }

    @Contract(pure=true)
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Contract(pure=true)
    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

