/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands;

import io.github.niestrat99.advancedteleport.commands.ATCommand;
import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.managers.CommandManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommand
extends ATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        SubATCommand help = CommandManager.subcommands.get("help");
        if (!sender.hasPermission("at.member.core")) {
            CustomMessages.sendMessage(sender, "Error.noPermission", new TagResolver[0]);
            return true;
        }
        if (args.length == 0) {
            help.onCommand(sender, cmd, s, args);
            return true;
        }
        String command = args[0].toLowerCase();
        if (!CommandManager.subcommands.containsKey(command)) {
            help.onCommand(sender, cmd, s, args);
            return true;
        }
        if (sender.hasPermission("at.member.core." + command) || sender.hasPermission("at.admin.core." + command)) {
            boolean correctUse = CommandManager.subcommands.get(command).onCommand(sender, cmd, s, Arrays.copyOfRange(args, 1, args.length));
            if (!correctUse) {
                CustomMessages.sendMessage(sender, "Error.commandUse", new TagResolver[]{Placeholder.component((String)"usage", (ComponentLike)CustomMessages.getComponent("Usages.Subcommands." + command, new TagResolver[0]))});
            }
        } else {
            CustomMessages.sendMessage(sender, "Error.noPermission", new TagResolver[0]);
        }
        return true;
    }

    @Override
    public boolean getRequiredFeature() {
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.core";
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (args.length > 1) {
            String command = args[0].toLowerCase();
            if (!CommandManager.subcommands.containsKey(command)) {
                return null;
            }
            return CommandManager.subcommands.get(command).onTabComplete(sender, cmd, s, Arrays.copyOfRange(args, 1, args.length));
        }
        ArrayList<String> availableCommands = new ArrayList<String>();
        ArrayList<String> chosenCommands = new ArrayList<String>();
        for (String command : CommandManager.subcommands.keySet()) {
            if (!sender.hasPermission("at.member.core." + command) && !sender.hasPermission("at.admin.core." + command)) continue;
            availableCommands.add(command);
        }
        StringUtil.copyPartialMatches((String)args[0], availableCommands, chosenCommands);
        return chosenCommands;
    }
}

