/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.managers.RTPManager;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClearCacheCommand
extends SubATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!RTPManager.isInitialised()) {
            CustomMessages.sendMessage(sender, "Error.rtpManagerNotUsed", new TagResolver[0]);
            return true;
        }
        if (args.length == 0) {
            RTPManager.clearEverything();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
                for (World world : Bukkit.getWorlds()) {
                    RTPManager.loadWorldData(world);
                }
            });
            CustomMessages.sendMessage(sender, "Info.clearEverything", new TagResolver[0]);
            return true;
        }
        World world = Bukkit.getWorld((String)args[0]);
        if (world == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchWorld", new TagResolver[0]);
            return true;
        }
        RTPManager.unloadWorldData(world);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> RTPManager.loadWorldData(world));
        CustomMessages.sendMessage(sender, "Info.clearWorld", new TagResolver[]{Placeholder.unparsed((String)"world", (String)args[0])});
        return true;
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList options = new ArrayList();
            Bukkit.getWorlds().forEach(world -> options.add(world.getName()));
            StringUtil.copyPartialMatches((String)args[0], options, results);
        }
        return results;
    }
}

