/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core;

import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.hooks.ImportExportPlugin;
import io.github.niestrat99.advancedteleport.hooks.PluginHook;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportCommand
extends SubATCommand {
    @Nullable
    static ImportExportPlugin<?, ?> getImportExportPlugin(@NotNull CommandSender sender, @NotNull @NotNull String @NotNull [] args) {
        String pluginStr = args[0].toLowerCase();
        ImportExportPlugin plugin = PluginHookManager.get().getPluginHook(pluginStr, ImportExportPlugin.class);
        if (plugin == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchPlugin", new TagResolver[0]);
            return null;
        }
        if (!plugin.canImport()) {
            CustomMessages.sendMessage(sender, "Error.cantImport", new TagResolver[]{Placeholder.unparsed((String)"plugin", (String)args[0])});
            return null;
        }
        return plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 0) {
            CustomMessages.sendMessage(sender, "Error.noPluginSpecified", new TagResolver[0]);
            return false;
        }
        ImportExportPlugin<?, ?> pluginHook = ImportCommand.getImportExportPlugin(sender, args);
        if (pluginHook == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchPlugin", new TagResolver[0]);
            return true;
        }
        String arg = args.length == 1 ? "all" : args[1].toLowerCase();
        CustomMessages.sendMessage(sender, "Info.importStarted", new TagResolver[]{Placeholder.unparsed((String)"plugin", (String)args[0])});
        switch (arg) {
            case "homes": {
                pluginHook.importHomes();
                break;
            }
            case "warps": {
                pluginHook.importWarps();
                break;
            }
            case "lastlocs": {
                pluginHook.importLastLocations();
                break;
            }
            case "spawns": {
                pluginHook.importSpawn();
                break;
            }
            case "players": {
                pluginHook.importPlayerInformation();
                break;
            }
            case "all": {
                pluginHook.importAll();
                break;
            }
            default: {
                CustomMessages.sendMessage(sender, "Error.invalidOption", new TagResolver[0]);
                return false;
            }
        }
        CustomMessages.sendMessage(sender, "Info.importFinished", new TagResolver[]{Placeholder.unparsed((String)"plugin", (String)args[0])});
        return true;
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> possibilities = new ArrayList<String>();
        if (args.length == 1) {
            possibilities.addAll(PluginHookManager.get().getPluginHooks(ImportExportPlugin.class).map(PluginHook::pluginName).toList());
        }
        if (args.length == 2) {
            possibilities.addAll(Arrays.asList("all", "homes", "lastlocs", "warps", "spawns", "players"));
        }
        return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], possibilities, new ArrayList());
    }
}

