/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core;

import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.hooks.ParticlesPlugin;
import io.github.niestrat99.advancedteleport.managers.ParticleManager;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ParticlesCommand
extends SubATCommand {
    private final HashSet<String> types = new HashSet<String>(Arrays.asList("home", "tpa", "tpahere", "tpr", "warp", "spawn", "back"));

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!MainConfig.get().USE_PARTICLES.get().booleanValue()) {
            CustomMessages.sendMessage(sender, "Error.featureDisabled", new TagResolver[0]);
            return true;
        }
        if (PluginHookManager.get().getPluginHooks(ParticlesPlugin.class).findAny().isEmpty()) {
            CustomMessages.sendMessage(sender, "Error.noParticlePlugins", new TagResolver[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            CustomMessages.sendMessage(sender, "Error.notAPlayer", new TagResolver[0]);
            return true;
        }
        Player player = (Player)sender;
        String data = ParticleManager.getData(player);
        if (args.length == 0) {
            if (data == null) {
                data = "";
            }
            MainConfig.get().set("default-waiting-particles", data);
            CustomMessages.sendMessage(sender, "Info.defaultParticlesUpdated", new TagResolver[0]);
        } else {
            String type;
            if (data == null) {
                data = "default";
            }
            if (!this.types.contains(type = args[0])) {
                return true;
            }
            MainConfig.get().set("waiting-particles." + type, data);
            CustomMessages.sendMessage(sender, "Info.specificParticlesUpdated", new TagResolver[]{Placeholder.unparsed((String)"type", (String)type)});
        }
        try {
            MainConfig.get().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        return (List)StringUtil.copyPartialMatches((String)args[0], this.types, new ArrayList());
    }
}

