/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.core;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.config.ATConfig;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.GUIConfig;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.CommandManager;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.utilities.RandomCoords;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReloadCommand
extends SubATCommand {
    @Contract(value="_, _, _, _ -> true")
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        CustomMessages.sendMessage(sender, "Info.reloadingConfig", new TagResolver[0]);
        for (ATConfig config : Arrays.asList(new ATConfig[]{MainConfig.get(), CustomMessages.config, GUIConfig.get()})) {
            try {
                config.reload();
            }
            catch (Exception ex) {
                CoreClass.getInstance().getLogger().warning("Failed to load " + config.getFile().getName() + ": " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        RandomCoords.reload();
        CooldownManager.init();
        CommandManager.registerCommands();
        CustomMessages.sendMessage(sender, "Info.reloadedConfig", new TagResolver[0]);
        return true;
    }

    @Override
    @Contract(value="_, _, _, _ -> null", pure=true)
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return null;
    }
}

