/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.home;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.home.AbstractHomeCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class DelHomeCommand
extends AbstractHomeCommand
implements PlayerCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            if (sender.hasPermission(this.getAdminPermission()) && args.length > 1) {
                AdvancedTeleportAPI.getOfflinePlayer(args[0]).whenCompleteAsync((target, err) -> this.delHome((OfflinePlayer)target, player, args[1]), CoreClass.sync);
                return true;
            }
            this.delHome(player, args[0]);
            return true;
        }
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        if (PluginHookManager.get().floodgateEnabled() && atPlayer instanceof ATFloodgatePlayer) {
            ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
            if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                if (!atFloodgatePlayer.getHomes().isEmpty()) {
                    atFloodgatePlayer.sendDeleteHomeForm();
                    return true;
                }
                CustomMessages.sendMessage(sender, "Error.noHomes", new TagResolver[0]);
                return true;
            }
        }
        CustomMessages.sendMessage(sender, "Error.noHomeInput", new TagResolver[0]);
        return false;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.delhome";
    }

    @Override
    @NotNull
    public String getAdminPermission() {
        return "at.admin.delhome";
    }

    private void delHome(OfflinePlayer player, Player sender, String name) {
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        if (!atPlayer.hasHome(name)) {
            CustomMessages.sendMessage((CommandSender)sender, "Error.noSuchHome", new TagResolver[0]);
            return;
        }
        atPlayer.removeHome(name, (CommandSender)sender).whenComplete((ignored, err) -> CustomMessages.failableContextualPath((CommandSender)sender, player, "Info.deletedHome", "Error.deleteHomeFail", err, new TagResolver[]{Placeholder.unparsed((String)"home", (String)name), Placeholder.unparsed((String)"player", (String)player.getName())}));
    }

    private void delHome(@NotNull Player player, @NotNull String name) {
        this.delHome((OfflinePlayer)player, player, name);
    }
}

