/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.home;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.home.AbstractHomeCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class MoveHomeCommand
extends AbstractHomeCommand
implements PlayerCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        if (args.length == 0) {
            if (atPlayer instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    if (!atFloodgatePlayer.getHomes().isEmpty()) {
                        atFloodgatePlayer.sendMoveHomeForm();
                        return true;
                    }
                    CustomMessages.sendMessage(sender, "Error.noHomes", new TagResolver[0]);
                    return true;
                }
            }
            CustomMessages.sendMessage(sender, "Error.noHomeInput", new TagResolver[0]);
            return false;
        }
        if (sender.hasPermission(this.getAdminPermission()) && args.length > 1) {
            ATPlayer.getPlayerFuture(args[0]).thenAccept(atTarget -> {
                if (!atTarget.getHomes().containsKey((Object)args[1])) {
                    CustomMessages.sendMessage(sender, "Error.noSuchHome", new TagResolver[0]);
                    return;
                }
                atTarget.moveHome(args[0], player.getLocation(), sender).whenCompleteAsync((ignored, err) -> CustomMessages.failableContextualPath(sender, atTarget, "Info.movedHome", "Error.moveHomeFail", err, new TagResolver[]{Placeholder.unparsed((String)"home", (String)args[1]), Placeholder.unparsed((String)"player", (String)args[0])}));
            });
            return true;
        }
        Home home = atPlayer.getHome(args[0]);
        if (home == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchHome", new TagResolver[0]);
            return true;
        }
        atPlayer.moveHome(args[0], player.getLocation(), sender).whenCompleteAsync((ignored, err) -> CustomMessages.failableContextualPath(sender, atPlayer, "Info.movedHome", "Error.moveHomeFail", err, new TagResolver[]{Placeholder.unparsed((String)"home", (String)args[0])}));
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.movehome";
    }

    @Override
    @NotNull
    public String getAdminPermission() {
        return "at.admin.movehome";
    }
}

