/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.home;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.api.data.ATException;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.home.AbstractHomeCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class SetMainHomeCommand
extends AbstractHomeCommand
implements PlayerCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        if (args.length == 0) {
            if (!(atPlayer instanceof ATFloodgatePlayer) || !MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                CustomMessages.sendMessage(sender, "Error.noHomeInput", new TagResolver[0]);
                return false;
            }
            ((ATFloodgatePlayer)atPlayer).sendSetMainHomeForm();
            return true;
        }
        if (args.length > 1 && sender.hasPermission(this.getAdminPermission()) && !args[0].equalsIgnoreCase(sender.getName())) {
            AdvancedTeleportAPI.getOfflinePlayer(args[0]).whenCompleteAsync((target, err1) -> {
                String homeName;
                ATPlayer atTarget = ATPlayer.getPlayer(target);
                if (atTarget.hasHome(homeName = args[1])) {
                    atTarget.setMainHome(homeName, sender).whenCompleteAsync((ignored, err) -> CustomMessages.failableContextualPath(sender, target, "Info.setMainHome", "Error.setMainHomeFail", err, new TagResolver[]{Placeholder.unparsed((String)"home", (String)homeName), Placeholder.unparsed((String)"player", (String)args[0])}));
                    return;
                }
                if (atPlayer.canSetMoreHomes()) {
                    this.addAndMaybeSetHome(sender, atTarget, player, homeName);
                    return;
                }
                atTarget.setMainHome(homeName, sender).whenCompleteAsync((ignore, err) -> CustomMessages.failableContextualPath(sender, target, "Info.setMainHome", "Error.setMainHomeFail", err, new TagResolver[]{Placeholder.unparsed((String)"home", (String)homeName), Placeholder.unparsed((String)"player", (String)args[0])}));
            });
            return true;
        }
        String homeName = args[0];
        Home home = atPlayer.getHome(homeName);
        if (home == null) {
            if (atPlayer.canSetMoreHomes()) {
                this.addAndMaybeSetHome(sender, atPlayer, player, homeName);
            }
        } else if (atPlayer.canAccessHome(home)) {
            atPlayer.setMainHome(homeName, sender).whenCompleteAsync((ignored, err) -> CustomMessages.failable(sender, "Info.setMainHome", "Error.setMainHomeFail", err, new TagResolver[]{Placeholder.unparsed((String)"home", (String)homeName)}));
        } else {
            CustomMessages.sendMessage(sender, "Error.noAccessHome", new TagResolver[]{Placeholder.unparsed((String)"home", (String)home.getName())});
        }
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.setmainhome";
    }

    @Override
    @NotNull
    public String getAdminPermission() {
        return "at.admin.setmainhome";
    }

    private void addAndMaybeSetHome(@NotNull CommandSender sender, @NotNull ATPlayer atTarget, @NotNull Player player, @NotNull String homeName) {
        atTarget.addHome(homeName, player.getLocation(), player).whenCompleteAsync((ignored, err) -> {
            if (err != null) {
                CustomMessages.sendMessage(sender, "Error.setHomeFail", new TagResolver[]{Placeholder.unparsed((String)"home", (String)homeName)});
                if (!(err instanceof ATException)) {
                    err.printStackTrace();
                }
                return;
            }
            atTarget.setMainHome(homeName, sender).whenCompleteAsync((ignored2, err2) -> CustomMessages.failableContextualPath(sender, atTarget, "Info.setAndMadeMainHome", "Error.setMainHomeFail", err2, new TagResolver[]{Placeholder.unparsed((String)"home", (String)homeName), Placeholder.component((String)"player", (ComponentLike)atTarget.getPlayer().displayName())}));
        });
    }
}

