/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.commands.TimedATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.utilities.DistanceLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Back
extends TeleportATCommand
implements TimedATCommand {
    private final Predicate<Material> IS_AIR_OR_WATER = mat -> mat.isAir() || mat == Material.WATER;

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0 && sender.hasPermission("at.admin.back") && (player = Bukkit.getPlayer((String)args[0])) == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchPlayer", new TagResolver[0]);
            return true;
        }
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        Location loc = atPlayer.getPreviousLocation();
        if (loc == null) {
            CustomMessages.sendMessage(sender, "Error.noLocation", new TagResolver[0]);
            return true;
        }
        double originalY = loc.getY();
        double originalX = loc.getX();
        double originalZ = loc.getZ();
        int radius = MainConfig.get().BACK_SEARCH_RADIUS.get();
        ArrayList<Location> possiblelocs = new ArrayList<Location>();
        Location t = new Location(loc.getWorld(), originalX, originalY, originalZ);
        for (int dx = -radius; dx <= radius; ++dx) {
            t.setX(originalX - (double)dx);
            for (int dz = -radius; dz <= radius; ++dz) {
                t.setZ(originalZ - (double)dz);
                for (int dy = -radius; dy <= radius; ++dy) {
                    t.setY(originalY - (double)dy);
                    Material material = t.getBlock().getType();
                    if (material.name().equals("LAVA") || this.IS_AIR_OR_WATER.test(material) || !this.IS_AIR_OR_WATER.test(t.clone().add(0.0, 1.0, 0.0).getBlock().getType()) || !this.IS_AIR_OR_WATER.test(t.clone().add(0.0, 2.0, 0.0).getBlock().getType())) continue;
                    possiblelocs.add(new Location(loc.getWorld(), (double)(loc.getBlockX() - dx) + 0.5, (double)(loc.getBlockY() - dy) + 1.0, (double)(loc.getBlockZ() - dz) + 0.5));
                }
            }
        }
        while (possiblelocs.size() > 1) {
            if (loc.distanceSquared((Location)possiblelocs.get(1)) > loc.distanceSquared((Location)possiblelocs.get(0))) {
                possiblelocs.remove(1);
                continue;
            }
            possiblelocs.remove(0);
        }
        if (possiblelocs.size() == 1) {
            loc = (Location)possiblelocs.get(0);
        }
        int lavablocks = 0;
        Material material = loc.getBlock().getType();
        while (!this.IS_AIR_OR_WATER.test(material) && possiblelocs.isEmpty()) {
            if (material.name().equalsIgnoreCase("Lava")) {
                ++lavablocks;
            }
            if (loc.getY() > (double)loc.getWorld().getMaxHeight() || lavablocks > 5) {
                loc.setY(originalY);
                break;
            }
            loc.add(0.0, 1.0, 0.0);
        }
        if (!DistanceLimiter.canTeleport(player.getLocation(), loc, "back", ATPlayer.getPlayer(player)) && !player.hasPermission("at.admin.bypass.distance-limit")) {
            CustomMessages.sendMessage((CommandSender)player, "Error.tooFarAway", new TagResolver[0]);
            return true;
        }
        ATTeleportEvent event = new ATTeleportEvent(player, loc, player.getLocation(), "back", ATTeleportEvent.TeleportType.BACK);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return true;
        }
        if (sender != player) {
            CustomMessages.sendMessage((CommandSender)player, "Teleport.teleportingToLastLoc", new TagResolver[0]);
            player.teleport(loc);
        } else {
            atPlayer.teleport(event, "back", "Teleport.teleportingToLastLoc");
        }
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.back";
    }

    @Override
    @NotNull
    public String getSection() {
        return "back";
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return null;
    }
}

