/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.TeleportRequest;
import io.github.niestrat99.advancedteleport.api.TeleportRequestType;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.utilities.ConditionChecker;
import java.util.List;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TpAll
extends TeleportATCommand
implements PlayerCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        final Player player = (Player)sender;
        int cooldown = CooldownManager.secondsLeftOnCooldown("tpahere", player);
        if (cooldown > 0) {
            CustomMessages.sendMessage(sender, "Error.onCooldown", new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(cooldown))});
            return true;
        }
        int players = 0;
        int requestLifetime = MainConfig.get().REQUEST_LIFETIME.get();
        for (final Player target : Bukkit.getOnlinePlayers()) {
            if (target == player || ConditionChecker.canTeleport(player, target, "tpahere") != null) continue;
            ++players;
            CustomMessages.sendMessage((CommandSender)target, "Info.tpaRequestHere", new TagResolver[]{Placeholder.unparsed((String)"player", (String)sender.getName()), Placeholder.unparsed((String)"lifetime", (String)String.valueOf(requestLifetime)), Placeholder.component((String)"lifetime-formatted", (ComponentLike)CustomMessages.toTime(requestLifetime))});
            BukkitRunnable run = new BukkitRunnable(){

                public void run() {
                    TeleportRequest.removeRequest(TeleportRequest.getRequestByReqAndResponder(target, player));
                }
            };
            run.runTaskLater((Plugin)CoreClass.getInstance(), (long)requestLifetime * 20L);
            TeleportRequest request = new TeleportRequest(player, target, run, TeleportRequestType.TPAHERE);
            TeleportRequest.addRequest(request);
            CooldownManager.addToCooldown("tpahere", player, player.getWorld());
        }
        if (players > 0) {
            CustomMessages.sendMessage((CommandSender)player, "Info.tpallRequestSent", new TagResolver[]{Placeholder.unparsed((String)"amount", (String)String.valueOf(players))});
        } else {
            CustomMessages.sendMessage((CommandSender)player, "Error.noRequestsSent", new TagResolver[0]);
        }
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.all";
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return null;
    }
}

