/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.TeleportRequest;
import io.github.niestrat99.advancedteleport.api.events.players.TeleportCancelEvent;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.utilities.PagedLists;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public final class TpCancel
extends TeleportATCommand
implements PlayerCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (TeleportRequest.getRequestsByRequester(player).isEmpty()) {
            CustomMessages.sendMessage(sender, "Error.noRequests", new TagResolver[0]);
            return true;
        }
        if (TeleportRequest.getRequestsByRequester(player).size() > 1) {
            if (args.length > 0) {
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target == null || !player.canSee(target)) {
                    CustomMessages.sendMessage(sender, "Errors.noSuchPlayer", new TagResolver[0]);
                    return true;
                }
                TeleportRequest request2 = TeleportRequest.getRequestByReqAndResponder(target, player);
                if (request2 == null) {
                    CustomMessages.sendMessage(sender, "Error.noRequestsFromPlayer", new TagResolver[]{Placeholder.unparsed((String)"player", (String)args[0])});
                    return true;
                }
                TeleportCancelEvent event = new TeleportCancelEvent(request2.responder(), request2.requester(), request2.type());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return true;
                }
                CustomMessages.sendMessage(sender, "Info.tpCancel", new TagResolver[0]);
                CustomMessages.sendMessage((CommandSender)request2.responder(), "Info.tpCancelResponder", new TagResolver[]{Placeholder.unparsed((String)"player", (String)player.getDisplayName())});
                request2.destroy();
                return true;
            }
            ATPlayer atPlayer = ATPlayer.getPlayer(player);
            if (atPlayer instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    List<String> responders = TeleportRequest.getRequestsByRequester(atFloodgatePlayer.getPlayer()).stream().map(request -> request.requester().getName()).toList();
                    if (!responders.isEmpty()) {
                        ((ATFloodgatePlayer)atPlayer).sendCancelForm(responders);
                        return true;
                    }
                    CustomMessages.sendMessage(sender, "Error.noRequests", new TagResolver[0]);
                    return true;
                }
            }
            PagedLists<TeleportRequest> requests = new PagedLists<TeleportRequest>(TeleportRequest.getRequestsByRequester(player), 8);
            CustomMessages.sendMessage((CommandSender)player, "Info.multipleRequestsCancel", new TagResolver[0]);
            Component component = Component.join((JoinConfiguration)JoinConfiguration.newlines(), requests.getContentsInPage(1).stream().map(request -> CustomMessages.get("Info.multipleRequestsIndex", new TagResolver[]{Placeholder.unparsed((String)"command", (String)"/tpcancel"), Placeholder.unparsed((String)"player", (String)request.requester().getName())})).toList());
            if (requests.getTotalPages() <= 1) return true;
            CustomMessages.sendMessage((CommandSender)player, component);
            CustomMessages.sendMessage((CommandSender)player, "Info.multipleRequestsList", new TagResolver[0]);
            return true;
        }
        TeleportRequest request3 = TeleportRequest.getRequestsByRequester(player).get(0);
        TeleportCancelEvent event = new TeleportCancelEvent(request3.requester(), request3.requester(), request3.type());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return true;
        }
        CustomMessages.sendMessage((CommandSender)request3.responder(), "Info.tpCancelResponder", new TagResolver[]{Placeholder.unparsed((String)"player", (String)player.getName())});
        CustomMessages.sendMessage((CommandSender)player, "Info.tpCancel", new TagResolver[0]);
        request3.destroy();
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.cancel";
    }
}

