/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.utilities.ConditionChecker;
import io.github.niestrat99.advancedteleport.utilities.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TpLoc
extends TeleportATCommand {
    private static final Pattern location = Pattern.compile("^(-)?\\d+(\\.\\d+)?$");

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Player target;
        Location location;
        if (!this.canProceed(sender)) {
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            location = this.getLocation(player, args);
            if (args.length > 6 && player.hasPermission("at.admin.tploc.others")) {
                target = Bukkit.getPlayer((String)args[6]);
                if (target == null || !target.isOnline()) {
                    CustomMessages.sendMessage((CommandSender)player, "Error.noSuchPlayer", new TagResolver[0]);
                    return true;
                }
            } else {
                target = player;
            }
        } else {
            Pair<Location, Player> pair = this.getLocation(sender, args);
            if (pair == null) {
                return false;
            }
            target = pair.snd();
            location = pair.fst();
        }
        if (location == null) {
            return false;
        }
        boolean allowFlight = true;
        if (args.length > 7 && target.hasPermission("at.admin.tploc.safe-teleport") && target.getAllowFlight()) {
            if (args[7].equalsIgnoreCase("precise")) {
                target.setFlying(true);
            } else if (args[7].equalsIgnoreCase("noflight")) {
                target.setFlying(false);
                allowFlight = false;
            }
        }
        ATTeleportEvent event = new ATTeleportEvent(target, location, target.getLocation(), "", ATTeleportEvent.TeleportType.TPLOC);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            Location blockBelow = location.clone().add(0.0, -1.0, 0.0);
            if (allowFlight && target.getAllowFlight() && target.hasPermission("at.admin.tploc.safe-teleport") && blockBelow.getBlock().getType() == Material.AIR) {
                target.setFlying(true);
            }
            ATPlayer.teleportWithOptions(target, location, PlayerTeleportEvent.TeleportCause.COMMAND);
            if (sender != target) {
                CustomMessages.sendMessage(sender, "Info.teleportedToLocOther", new TagResolver[]{Placeholder.unparsed((String)"x", (String)String.valueOf(location.getX())), Placeholder.unparsed((String)"y", (String)String.valueOf(location.getY())), Placeholder.unparsed((String)"z", (String)String.valueOf(location.getZ())), Placeholder.unparsed((String)"yaw", (String)String.valueOf(location.getYaw())), Placeholder.unparsed((String)"pitch", (String)String.valueOf(location.getPitch())), Placeholder.unparsed((String)"world", (String)location.getWorld().getName()), Placeholder.unparsed((String)"player", (String)args[6])});
            } else {
                CustomMessages.sendMessage(sender, "Info.teleportedToLoc", new TagResolver[]{Placeholder.unparsed((String)"x", (String)String.valueOf(location.getX())), Placeholder.unparsed((String)"y", (String)String.valueOf(location.getY())), Placeholder.unparsed((String)"z", (String)String.valueOf(location.getZ())), Placeholder.unparsed((String)"yaw", (String)String.valueOf(location.getYaw())), Placeholder.unparsed((String)"pitch", (String)String.valueOf(location.getPitch())), Placeholder.unparsed((String)"world", (String)location.getWorld().getName())});
            }
        }
        return true;
    }

    public static void a() {
        Calendar cal = Calendar.getInstance();
        if (cal.get(2) == 4 && cal.get(5) == 6) {
            CoreClass.getInstance().getLogger().info("Happy anniversary, TM and Nie!");
        }
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.tploc";
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Location location = player.getLocation();
            switch (args.length) {
                case 1: {
                    StringUtil.copyPartialMatches((String)args[0], Arrays.asList(String.valueOf(location.getX()), String.valueOf(location.getBlockX()), "~"), results);
                    break;
                }
                case 2: {
                    StringUtil.copyPartialMatches((String)args[1], Arrays.asList(String.valueOf(location.getY()), String.valueOf(location.getBlockY()), "~"), results);
                    break;
                }
                case 3: {
                    StringUtil.copyPartialMatches((String)args[2], Arrays.asList(String.valueOf(location.getZ()), String.valueOf(location.getBlockZ()), "~"), results);
                    break;
                }
                case 4: {
                    StringUtil.copyPartialMatches((String)args[3], Arrays.asList(String.valueOf(location.getYaw()), "~"), results);
                    break;
                }
                case 5: {
                    StringUtil.copyPartialMatches((String)args[4], Arrays.asList(String.valueOf(location.getPitch()), "~"), results);
                    break;
                }
                case 6: {
                    ArrayList<String> worlds = new ArrayList<String>();
                    for (World world : Bukkit.getWorlds()) {
                        worlds.add(world.getName());
                    }
                    worlds.add("~");
                    StringUtil.copyPartialMatches((String)args[5], worlds, results);
                    break;
                }
                case 7: {
                    if (!player.hasPermission("at.admin.tploc.others")) break;
                    StringUtil.copyPartialMatches((String)args[6], ConditionChecker.getPlayers(player), results);
                    break;
                }
                case 8: {
                    if (!player.hasPermission("at.admin.tploc.safe-teleport")) break;
                    StringUtil.copyPartialMatches((String)args[7], Arrays.asList("precise", "noflight"), results);
                }
            }
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private Location getLocation(@NotNull Player player, @NotNull String[] args) {
        if (args.length < 3) {
            CustomMessages.sendMessage((CommandSender)player, "Error.tooFewArguments", new TagResolver[0]);
            return null;
        }
        double[] loc = new double[3];
        for (int i = 0; i < 3; ++i) {
            if (args[i].equalsIgnoreCase("~")) {
                switch (i) {
                    case 0: {
                        loc[i] = player.getLocation().getX();
                        break;
                    }
                    case 1: {
                        loc[i] = player.getLocation().getY();
                        break;
                    }
                    case 2: {
                        loc[i] = player.getLocation().getZ();
                        break;
                    }
                }
                continue;
            }
            if (!location.matcher(args[i]).matches()) {
                CustomMessages.sendMessage((CommandSender)player, "Error.invalidArgs", new TagResolver[0]);
                return null;
            }
            loc[i] = Double.parseDouble(args[i]);
        }
        float yaw = player.getLocation().getYaw();
        float pitch = player.getLocation().getPitch();
        if (args.length > 3 && !args[3].equalsIgnoreCase("~")) {
            if (!location.matcher(args[3]).matches()) {
                CustomMessages.sendMessage((CommandSender)player, "Error.invalidArgs", new TagResolver[0]);
                return null;
            }
            yaw = Float.parseFloat(args[3]);
            if (args.length > 4 && !args[4].equalsIgnoreCase("~")) {
                if (!location.matcher(args[4]).matches()) {
                    CustomMessages.sendMessage((CommandSender)player, "Error.invalidArgs", new TagResolver[0]);
                    return null;
                }
                pitch = Float.parseFloat(args[4]);
            }
        }
        World world = player.getWorld();
        if (args.length > 5 && !args[5].equalsIgnoreCase("~") && (world = Bukkit.getWorld((String)args[5])) == null) {
            CustomMessages.sendMessage((CommandSender)player, "Error.noSuchWorld", new TagResolver[0]);
            return null;
        }
        return new Location(world, loc[0], loc[1], loc[2], yaw, pitch);
    }

    @Nullable
    private Pair<Location, Player> getLocation(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length < 7) {
            CustomMessages.sendMessage(sender, "Error.tooFewArguments", new TagResolver[0]);
            return null;
        }
        double[] loc = new double[3];
        for (int i = 0; i < 3; ++i) {
            if (!location.matcher(args[i]).matches()) {
                CustomMessages.sendMessage(sender, "Error.invalidArgs", new TagResolver[0]);
                return null;
            }
            loc[i] = Double.parseDouble(args[i]);
        }
        float[] dir = new float[2];
        for (int i = 0; i < 2; ++i) {
            if (!location.matcher(args[3 + i]).matches()) {
                CustomMessages.sendMessage(sender, "Error.invalidArgs", new TagResolver[0]);
                return null;
            }
            dir[i] = Float.parseFloat(args[3 + i]);
        }
        World world = Bukkit.getWorld((String)args[5]);
        if (world == null) {
            CustomMessages.sendMessage(sender, "Error.noSuchWorld", new TagResolver[0]);
            return null;
        }
        Location location = new Location(world, loc[0], loc[1], loc[2], dir[0], dir[1]);
        Player player = Bukkit.getPlayer((String)args[6]);
        if (player == null || !player.isOnline()) {
            CustomMessages.sendMessage(sender, "Error.noSuchPlayer", new TagResolver[0]);
            return null;
        }
        return new Pair<Location, Player>(location, player);
    }
}

