/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.teleport;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.commands.PlayerCommand;
import io.github.niestrat99.advancedteleport.commands.TeleportATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.libs.paperlib.PaperLib;
import io.github.niestrat99.advancedteleport.utilities.nbt.NBTReader;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class TpOffline
extends TeleportATCommand
implements PlayerCommand {
    public boolean onCommand(final @NotNull CommandSender sender, @NotNull Command command, @NotNull String s, final @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        if (args.length == 0) {
            CustomMessages.sendMessage(sender, "Error.noPlayerInput", new TagResolver[0]);
            return false;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target != null) {
            Bukkit.getServer().dispatchCommand(sender, "tpo " + args[0]);
            return true;
        }
        NBTReader.getLocation(args[0], new NBTReader.NBTCallback<Location>(){

            @Override
            public void onSuccess(Location data) {
                Bukkit.getScheduler().runTask((Plugin)CoreClass.getInstance(), () -> {
                    PaperLib.teleportAsync((Entity)((Player)sender), (Location)data);
                    CustomMessages.sendMessage(sender, "Teleport.teleportedToOfflinePlayer", new TagResolver[]{Placeholder.unparsed((String)"player", (String)args[0])});
                });
            }

            @Override
            public void onFail(@NotNull Component message) {
                CustomMessages.sendMessage(sender, message);
            }
        });
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.tpoffline";
    }
}

