/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.warp;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.commands.warp.AbstractWarpCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class MoveWarpCommand
extends AbstractWarpCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            ATPlayer atPlayer = ATPlayer.getPlayer(player);
            if (atPlayer instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    if (!AdvancedTeleportAPI.getWarps().isEmpty()) {
                        atFloodgatePlayer.sendMoveWarpForm();
                        return true;
                    }
                    CustomMessages.sendMessage(sender, "Error.noWarps", new TagResolver[0]);
                    return true;
                }
            }
            CustomMessages.sendMessage(sender, "Error.noWarpInput", new TagResolver[0]);
            return false;
        }
        Location warpLoc = player.getLocation();
        Warp warp = AdvancedTeleportAPI.getWarp(args[0]);
        if (warp != null) {
            warp.setLocation(warpLoc, sender).thenAcceptAsync(result -> CustomMessages.sendMessage(sender, "Info.movedWarp", new TagResolver[]{Placeholder.unparsed((String)"warp", (String)args[0])}));
            return true;
        }
        CustomMessages.sendMessage(sender, "Error.noSuchWarp", new TagResolver[0]);
        return true;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.admin.movewarp";
    }
}

