/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.config;

import io.github.niestrat99.advancedteleport.config.ATConfig;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.ConfigSection;
import java.util.ArrayList;
import java.util.Collections;

public final class GUIConfig
extends ATConfig {
    private static GUIConfig instance;

    public GUIConfig() throws Exception {
        super("guis.yml");
        instance = this;
    }

    public void addDefaults() {
        this.addDefault("warps.slots", 27);
        this.addDefault("warps.gui-enabled", false);
        this.addDefault("warps.icons.last-page.name", "&bLast Page");
        this.addDefault("warps.icons.last-page.item", "ARROW");
        this.addDefault("warps.icons.last-page.tooltip", new ArrayList());
        this.addDefault("warps.icons.last-page.slot", 18);
        this.addDefault("warps.icons.next-page.name", "&bNext Page");
        this.addDefault("warps.icons.next-page.item", "ARROW");
        this.addDefault("warps.icons.next-page.tooltip", new ArrayList());
        this.addDefault("warps.icons.next-page.slot", 26);
        this.makeSectionLenient("warps.warps");
        this.addComment("warps.warps.warpName1", "This is an example icon in the GUI.\nThe name - warpName1 - is the warp name used in /warp, e.g. /warp warpName1.");
        this.addExample("warps.warps.warpName1.name", "&aWarp Name 1", "The display name for the warp's item in the GUI.");
        this.addExample("warps.warps.warpName1.item", "DIAMOND_SWORD", "The item the warp is represented by in the GUI.\nIf you are on a legacy version (< v1.13), you can specify extra data by adding a data-value option, which takes an integer:\ndata-value: 1\nIf you are using a player head item (SKULL_ITEM and data-value: 3 or PLAYER_HEAD in new versions), you can specify a texture:\ntexture: eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjQxNDQ5MDk3YjRiNzlhOWY2Y2FmNjM0NDQxOGYyMDM0ZGU0YmI5NzFmZWI3YThlNGFhY2JmYjkwNWFjZGNlZiJ9fX0=\n");
        this.addExample("warps.warps.warpName1.tooltip", Collections.singletonList("&7Teleports you to warpName1"));
        this.addExample("warps.warps.warpName1.slot", 11, "The slot (starting from 0) that the warp should appear in.");
        this.addExample("warps.warps.warpName1.page", 0, "The page (starting from 0) that the warp should appear in.");
        this.addExample("warps.warps.warpName1.hide-if-no-permission", false, "Whether the warp should be hidden from the user or not if they don't have permission to it.");
        this.addExample("warps.warps.warpName2.name", "&7Warp Name 2");
        this.addExample("warps.warps.warpName2.item", "IRON_PICKAXE");
        this.addExample("warps.warps.warpName2.tooltip", Collections.singletonList("&7Teleports you to warpName2"));
        this.addExample("warps.warps.warpName2.slot", 13);
        this.addExample("warps.warps.warpName2.page", 0);
        this.addExample("warps.warps.warpName2.hide-if-no-permission", true);
    }

    public static GUIConfig get() {
        return instance;
    }

    public static ConfigSection getWarpsMenu() {
        return GUIConfig.get().getConfigSection("warps.warps");
    }

    public static int getWarpsMenuSlots() {
        return GUIConfig.get().getInteger("warps.slots");
    }

    public static boolean isUsingWarpsGUIMenu() {
        return GUIConfig.get().getBoolean("warps.gui-enabled");
    }

    public static ConfigSection getLastPageIcon() {
        return GUIConfig.get().getConfigSection("warps.icons.last-page");
    }

    public static ConfigSection getNextPageIcon() {
        return GUIConfig.get().getConfigSection("warps.icons.next-page");
    }
}

