/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginHook<P extends Plugin, R> {
    @NotNull
    private final Optional<String> pluginName;
    @Nullable
    private final Class<R> providerClazz;

    @Contract(pure=true)
    protected PluginHook(@Nullable String pluginName, @Nullable Class<R> provider) {
        this.pluginName = Optional.ofNullable(pluginName);
        this.providerClazz = provider;
    }

    @Contract(pure=true)
    protected PluginHook(@Nullable String pluginName) {
        this(pluginName, null);
    }

    @Contract(pure=true)
    @NotNull
    public String pluginName() {
        return this.pluginName.orElse("Unknown");
    }

    @Contract(pure=true)
    public boolean pluginUsable() {
        return this.plugin().map(Plugin::isEnabled).orElse(false);
    }

    @Contract(pure=true)
    @NotNull
    protected Optional<P> plugin() {
        return this.pluginName.filter(name -> !name.equals("Unknown")).map(name -> Bukkit.getServer().getPluginManager().getPlugin(name)).map(plugin -> plugin);
    }

    @Contract(pure=true)
    @NotNull
    protected Optional<R> provider() {
        if (this.providerClazz == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Bukkit.getServer().getServicesManager().getRegistration(this.providerClazz)).map(RegisteredServiceProvider::getProvider);
    }
}

