/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks.borders;

import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.hooks.BorderPlugin;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class VanillaBorderHook
extends BorderPlugin<Plugin, Void> {
    public VanillaBorderHook() {
        super(null);
    }

    @Override
    @Contract(pure=true)
    public boolean canUse(@NotNull World world) {
        return MainConfig.get().USE_VANILLA_BORDER.get() != false && world.getWorldBorder().getSize() != 5.9999968E7 && world.getWorldBorder().getSize() != 5.9999968E7;
    }

    @Override
    @Contract(pure=true)
    public double getMinX(@NotNull World world) {
        return this.getCentre(world).getX() - world.getWorldBorder().getSize() / 2.0;
    }

    @Override
    @Contract(pure=true)
    public double getMinZ(@NotNull World world) {
        return this.getCentre(world).getZ() - world.getWorldBorder().getSize() / 2.0;
    }

    @Override
    @Contract(pure=true)
    public double getMaxX(@NotNull World world) {
        return this.getCentre(world).getX() + world.getWorldBorder().getSize() / 2.0;
    }

    @Override
    @Contract(pure=true)
    public double getMaxZ(@NotNull World world) {
        return this.getCentre(world).getZ() + world.getWorldBorder().getSize() / 2.0;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Location getCentre(@NotNull World world) {
        return world.getWorldBorder().getCenter();
    }
}

