/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks.claims;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.hooks.ClaimPlugin;
import me.angeschossen.lands.api.LandsIntegration;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class LandsClaimHook
extends ClaimPlugin<Plugin, Void> {
    private LandsIntegration lands;

    @Contract(pure=true)
    public LandsClaimHook() {
        super("Lands");
    }

    @Override
    @Contract(pure=true)
    public boolean canUse(@NotNull World world) {
        if (!super.canUse(world)) {
            return false;
        }
        if (this.lands == null) {
            this.lands = LandsIntegration.of((Plugin)CoreClass.getInstance());
        }
        return true;
    }

    @Override
    @Contract(pure=true)
    public boolean isClaimed(@NotNull Location location) {
        return this.lands.getLandByChunk(location.getWorld(), Math.floorDiv(location.getBlockX(), 16), Math.floorDiv(location.getBlockZ(), 16)) != null;
    }
}

