/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks.claims;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import io.github.niestrat99.advancedteleport.hooks.ClaimPlugin;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class WorldGuardClaimHook
extends ClaimPlugin<Plugin, WorldGuard> {
    private RegionContainer container;

    public WorldGuardClaimHook() {
        super("WorldGuard", WorldGuard.class);
    }

    @Override
    @NotNull
    protected Optional<WorldGuard> provider() {
        return Optional.of(WorldGuard.getInstance());
    }

    @Override
    @Contract(pure=true)
    public boolean canUse(@NotNull World world) {
        if (!super.canUse(world)) {
            return false;
        }
        return this.provider().map(provider -> {
            this.container = provider.getPlatform().getRegionContainer();
            return this.container.get(BukkitAdapter.adapt((World)world)) != null;
        }).orElse(false);
    }

    @Override
    @Contract(pure=true)
    public boolean isClaimed(@NotNull Location location) {
        RegionQuery query = this.container.createQuery();
        return query.getApplicableRegions(BukkitAdapter.adapt((Location)location)).size() > 0;
    }
}

