/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks.imports;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserMap;
import com.earth2me.essentials.Warps;
import com.earth2me.essentials.commands.WarpNotFoundException;
import com.earth2me.essentials.spawn.EssentialsSpawn;
import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.api.WorldlessLocation;
import io.github.niestrat99.advancedteleport.hooks.ImportExportPlugin;
import io.github.niestrat99.advancedteleport.sql.PlayerSQLManager;
import io.github.niestrat99.advancedteleport.utilities.ConditionChecker;
import java.io.File;
import java.util.UUID;
import net.ess3.api.InvalidWorldException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EssentialsHook
extends ImportExportPlugin<Essentials, Void> {
    private Essentials essentials;

    public EssentialsHook() {
        super("Essentials");
    }

    @Override
    @Contract(pure=true)
    public boolean canImport() {
        return this.plugin().map(essentials -> {
            this.essentials = essentials;
            return true;
        }).orElse(false);
    }

    @Override
    public void importHomes() {
        this.debug("Importing homes...");
        if (this.essentials == null) {
            return;
        }
        UserMap userMap = this.essentials.getUserMap();
        if (userMap == null) {
            return;
        }
        for (UUID uuid : userMap.getAllUniqueUsers()) {
            try {
                User user = this.getUser(uuid);
                if (user == null || user.getName() == null) continue;
                for (String home : user.getHomes()) {
                    Location loc = user.getHome(home);
                    ATPlayer.getPlayerFuture(user.getName()).thenAcceptAsync(player -> {
                        if (!player.hasHome(home)) {
                            player.addHome(home, loc, null, false);
                        } else {
                            player.moveHome(home, loc);
                        }
                    }, CoreClass.sync);
                }
            }
            catch (Exception ex) {
                this.debug("Failed to export previous locations for UUID " + uuid.toString() + ":");
                ex.printStackTrace();
            }
        }
        this.debug("Finished importing homes!");
    }

    @Nullable
    private User getUser(@NotNull UUID uuid) {
        try {
            UserMap userMap = this.essentials.getUserMap();
            if (userMap == null) {
                return null;
            }
            return userMap.getUser(uuid);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Override
    public void importLastLocations() {
        this.debug("Importing last locations...");
        if (this.essentials == null) {
            return;
        }
        UserMap userMap = this.essentials.getUserMap();
        if (userMap == null) {
            return;
        }
        for (UUID uuid : userMap.getAllUniqueUsers()) {
            try {
                User user = userMap.getUser(uuid);
                if (user == null || user.getName() == null || user.getLastLocation() == null || user.getLastLocation().getWorld() == null) continue;
                if (ATPlayer.isPlayerCached(user.getName())) {
                    ATPlayer player = ATPlayer.getPlayer(user.getName());
                    player.setPreviousLocation(user.getLastLocation());
                    continue;
                }
                PlayerSQLManager.get().setPreviousLocation(user.getName(), user.getLastLocation());
            }
            catch (Exception ex) {
                this.debug("Failed to export previous locations for UUID " + uuid.toString() + ":");
                ex.printStackTrace();
            }
        }
        this.debug("Finished importing last locations!");
    }

    @Override
    public void importWarps() {
        this.debug("Importing warps...");
        if (this.essentials == null) {
            return;
        }
        Warps warps = this.essentials.getWarps();
        if (warps == null) {
            return;
        }
        for (String warp : warps.getList()) {
            try {
                Warp warpObj = AdvancedTeleportAPI.getWarp(warp);
                if (warpObj != null) {
                    Location loc = warps.getWarp(warp);
                    warpObj.setLocation(loc);
                    continue;
                }
                UUID uuid = warps.getLastOwner(warp);
                Location loc = warps.getWarp(warp);
                AdvancedTeleportAPI.setWarp(warp, (CommandSender)Bukkit.getPlayer((UUID)uuid), loc);
            }
            catch (WarpNotFoundException ex) {
                CoreClass.getInstance().getLogger().warning("Failed to import warp " + warp + " from Essentials - apparently it does not exist.");
            }
            catch (InvalidWorldException e) {
                CoreClass.getInstance().getLogger().warning("Failed to import warp " + warp + " from Essentials - the world is not loaded/invalid.");
            }
        }
        this.debug("Finished importing warps!");
    }

    @Override
    public void importSpawn() {
        this.debug("Importing spawnpoints...");
        EssentialsSpawn spawnPlugin = (EssentialsSpawn)Bukkit.getPluginManager().getPlugin("EssentialsSpawn");
        if (spawnPlugin == null || !spawnPlugin.isEnabled()) {
            return;
        }
        File spawnFileEss = this.plugin().map(essentials -> new File(essentials.getDataFolder(), "spawn.yml")).get();
        if (!spawnFileEss.exists() || !spawnFileEss.isFile()) {
            this.debug("Spawn file doesn't exist/wasn't found, skipping...");
            return;
        }
        YamlConfiguration spawn = YamlConfiguration.loadConfiguration((File)spawnFileEss);
        ConfigurationSection spawns = spawn.getConfigurationSection("spawns");
        if (spawns == null) {
            this.debug("Spawns section of the spawn file doesn't exist, skipping...");
            return;
        }
        boolean setMainSpawn = false;
        for (String key : spawns.getKeys(false)) {
            try {
                ConfigurationSection spawnSection = spawns.getConfigurationSection(key);
                if (spawnSection == null) continue;
                WorldlessLocation loc = EssentialsHook.getLocationFromSection(spawnSection);
                Spawn spawn1 = AdvancedTeleportAPI.setSpawn(key, null, loc).join();
                this.debug("Set spawn for " + key);
                if (key.equals("default")) {
                    setMainSpawn = true;
                    AdvancedTeleportAPI.setMainSpawn(spawn1, null);
                    this.debug("Set main spawn");
                    continue;
                }
                if (CoreClass.getPerms() == null || !CoreClass.getPerms().hasGroupSupport()) continue;
                CoreClass.getPerms().groupAdd((String)null, key, "at.member.spawn." + key);
                this.debug("Added at.member.spawn." + key + " to group " + key);
            }
            catch (Exception ex) {
                CoreClass.getInstance().getLogger().warning("Failed to import spawn " + key + "!");
                CoreClass.getInstance().getLogger().throwing(EssentialsHook.class.getName(), "importSpawn", ex);
            }
        }
        if (!setMainSpawn) {
            this.debug("Removed main spawn");
            AdvancedTeleportAPI.setMainSpawn(null, null);
        }
        this.debug("Finished importing spawns");
    }

    @Override
    public void importPlayerInformation() {
        this.debug("Importing player information...");
        if (this.essentials == null) {
            return;
        }
        UserMap userMap = this.essentials.getUserMap();
        if (userMap == null) {
            return;
        }
        for (UUID uuid : userMap.getAllUniqueUsers()) {
            try {
                User user = this.getUser(uuid);
                if (user == null || user.getName() == null) continue;
                if (!ATPlayer.isPlayerCached(user.getName())) {
                    PlayerSQLManager.get().setTeleportationOn(uuid, user.isTeleportEnabled());
                    continue;
                }
                ATPlayer player = ATPlayer.getPlayer(user.getName());
                player.setTeleportationEnabled(user.isTeleportEnabled());
            }
            catch (Exception ex) {
                this.debug("Failed to import player data for UUID " + uuid.toString() + ":");
                ex.printStackTrace();
            }
        }
        this.debug("Imported player information!");
    }

    @Override
    public void exportHomes() {
        this.debug("Exporting homes...");
        this.debug("WARNING: Essentials does not have a \"main home\" system so all main homes in AT will be ignored when exporting.");
        if (this.essentials == null) {
            return;
        }
        UserMap userMap = this.essentials.getUserMap();
        if (userMap == null) {
            return;
        }
        for (UUID uuid : userMap.getAllUniqueUsers()) {
            try {
                User user = this.getUser(uuid);
                if (user == null || user.getName() == null) continue;
                ATPlayer.getPlayerFuture(user.getName()).thenAcceptAsync(player -> {
                    for (String home : player.getHomes().keySet()) {
                        user.setHome(home, player.getHome(home).getLocation());
                    }
                }, CoreClass.sync);
            }
            catch (Exception ex) {
                this.debug("Failed to export home data for UUID " + uuid.toString() + ":");
                ex.printStackTrace();
            }
        }
        this.debug("Finished exporting homes!");
    }

    @Override
    public void exportLastLocations() {
        this.debug("Exporting previous locations...");
        if (this.essentials == null) {
            return;
        }
        UserMap userMap = this.essentials.getUserMap();
        if (userMap == null) {
            return;
        }
        for (UUID uuid : userMap.getAllUniqueUsers()) {
            try {
                User user = this.getUser(uuid);
                if (user == null || user.getName() == null) continue;
                ATPlayer.getPlayerFuture(user.getName()).thenAcceptAsync(player -> user.setLastLocation(player.getPreviousLocation()), CoreClass.sync);
            }
            catch (Exception ex) {
                this.debug("Failed to export previous locations for UUID " + uuid.toString() + ":");
                ex.printStackTrace();
            }
        }
        this.debug("Finished exporting previous locations!");
    }

    @Override
    public void exportWarps() {
        this.debug("Exporting warps...");
        if (this.essentials == null) {
            return;
        }
        Warps warps = this.essentials.getWarps();
        if (warps == null) {
            return;
        }
        for (Warp warp : AdvancedTeleportAPI.getWarps().values()) {
            try {
                warps.setWarp(warp.getName(), warp.getLocation());
            }
            catch (Exception e) {
                this.debug("Failed to export warp " + warp.getName() + ":");
                e.printStackTrace();
            }
        }
        this.debug("Finished exporting warps!");
    }

    @Override
    public void exportSpawn() {
        this.debug("Exporting spawnpoints...");
        this.debug("WARNING - any changes made to the spawnpoints may be dodgy due to the differences between Essentials and AT's spawn systems.");
        this.debug("If you notice any problems, please fix them yourself.");
        EssentialsSpawn spawnPlugin = (EssentialsSpawn)Bukkit.getPluginManager().getPlugin("EssentialsSpawn");
        if (spawnPlugin == null || !spawnPlugin.isEnabled()) {
            return;
        }
        Spawn mainSpawn = AdvancedTeleportAPI.getMainSpawn();
        if (mainSpawn != null) {
            spawnPlugin.setSpawn(mainSpawn.getLocation(), "default");
        }
        for (Spawn atSpawn : AdvancedTeleportAPI.getSpawns().values()) {
            for (String group : CoreClass.getPerms().getGroups()) {
                if (!CoreClass.getPerms().groupHas((World)null, group, atSpawn.getName())) continue;
                spawnPlugin.setSpawn(atSpawn.getLocation(), group);
            }
        }
        this.debug("Finished exporting spawns!");
    }

    @Override
    public void exportPlayerInformation() {
        this.debug("Exporting player information...");
        if (this.essentials == null) {
            return;
        }
        UserMap userMap = this.essentials.getUserMap();
        if (userMap == null) {
            return;
        }
        for (UUID uuid : userMap.getAllUniqueUsers()) {
            try {
                User user = this.getUser(uuid);
                if (user == null || user.getName() == null) continue;
                ATPlayer.getPlayerFuture(user.getName()).thenAcceptAsync(player -> user.setTeleportEnabled(player.isTeleportationEnabled()), CoreClass.async);
            }
            catch (Exception ex) {
                this.debug("Failed to export player information for UUID " + uuid.toString() + ":");
                ex.printStackTrace();
            }
        }
    }

    private static WorldlessLocation getLocationFromSection(ConfigurationSection section) {
        String world = ConditionChecker.validate(section.getString("world"), "World is null");
        double x = section.getDouble("x");
        double y = section.getDouble("y");
        double z = section.getDouble("z");
        float yaw = (float)section.getDouble("yaw");
        float pitch = (float)section.getDouble("pitch");
        return new WorldlessLocation(world, x, y, z, yaw, pitch);
    }
}

