/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks.maps;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.hooks.MapPlugin;
import io.github.niestrat99.advancedteleport.managers.MapAssetManager;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynmapHook
extends MapPlugin<Plugin, Void> {
    private MarkerAPI markerAPI;
    @Nullable
    private MarkerSet warpsMarker;
    @Nullable
    private MarkerSet homesMarker;
    @Nullable
    private MarkerSet spawnsMarker;
    private HashMap<String, MarkerIcon> icons;

    public DynmapHook() {
        super("dynmap");
    }

    @Override
    @Contract(pure=true)
    public void enable() {
        CoreClass.getInstance().getLogger().info("Found Dynmap, hooking...");
        this.icons = new HashMap();
        this.plugin().map(DynmapAPI.class::cast).ifPresent(api -> {
            this.markerAPI = api.getMarkerAPI();
            this.warpsMarker = this.getSet("advancedteleport_warps", "Warps");
            this.homesMarker = this.getSet("advancedteleport_homes", "Homes");
            this.spawnsMarker = this.getSet("advancedteleport_spawns", "Spawns");
        });
    }

    @Override
    public void addWarp(@NotNull Warp warp) {
        this.addMarker("advancedteleport_warp_" + warp.getName(), warp.getName(), MapAssetManager.IconType.WARP, null, this.warpsMarker, warp.getLocation());
    }

    @Override
    public void addHome(@NotNull Home home) {
        this.addMarker("advancedteleport_home_" + String.valueOf(home.getOwner()) + "_" + home.getName(), home.getName(), MapAssetManager.IconType.HOME, home.getOwner(), this.homesMarker, home.getLocation());
    }

    @Override
    public void addSpawn(@NotNull Spawn spawn) {
        this.addMarker("advancedteleport_spawn_" + spawn.getName(), spawn.getName(), MapAssetManager.IconType.SPAWN, null, this.spawnsMarker, spawn.getLocation());
    }

    @Override
    public void removeWarp(@NotNull Warp warp) {
        this.removeMarker("advancedteleport_warp_" + warp.getName(), this.warpsMarker);
    }

    @Override
    public void removeHome(@NotNull Home home) {
        this.removeMarker("advancedteleport_home_" + String.valueOf(home.getOwner()) + "_" + home.getName(), this.homesMarker);
    }

    @Override
    public void removeSpawn(@NotNull Spawn spawn) {
        this.removeMarker("advancedteleport_spawn_" + spawn.getName(), this.spawnsMarker);
    }

    @Override
    public void moveWarp(@NotNull Warp warp) {
        this.moveMarker("advancedteleport_warp_" + warp.getName(), warp.getName(), this.warpsMarker, MapAssetManager.IconType.WARP, null, warp.getLocation());
    }

    @Override
    public void moveHome(@NotNull Home home) {
        this.moveMarker("advancedteleport_home_" + String.valueOf(home.getOwner()) + "_" + home.getName(), home.getName(), this.homesMarker, MapAssetManager.IconType.HOME, home.getOwner(), home.getLocation());
    }

    @Override
    public void moveSpawn(@NotNull Spawn spawn) {
        this.moveMarker("advancedteleport_spawn_" + spawn.getName(), spawn.getName(), this.spawnsMarker, MapAssetManager.IconType.SPAWN, null, spawn.getLocation());
    }

    @Override
    public void registerImage(@NotNull String name, @NotNull InputStream stream) {
        MarkerIcon icon = this.markerAPI.createMarkerIcon(name, name, stream);
        this.icons.put(name, icon);
    }

    private void addMarker(@NotNull String name, @NotNull String displayName, @NotNull MapAssetManager.IconType type, @Nullable UUID owner, @NotNull MarkerSet set, @NotNull Location location) {
        MapAssetManager.getIcon(name, type, owner).thenAcceptAsync(iconData -> {
            if (iconData == null) {
                return;
            }
            if (!iconData.shown()) {
                return;
            }
            set.createMarker(name, iconData.hoverTooltip().replace("{name}", displayName), location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), this.icons.get(iconData.imageKey()), false);
        }, CoreClass.sync);
    }

    private void removeMarker(@NotNull String name, @NotNull MarkerSet set) {
        for (Marker marker : set.getMarkers()) {
            if (!marker.getMarkerID().equals(name)) continue;
            marker.deleteMarker();
        }
    }

    private void moveMarker(@NotNull String name, @NotNull String displayName, @Nullable MarkerSet set, @NotNull MapAssetManager.IconType type, @Nullable UUID owner, @NotNull Location location) {
        if (set == null) {
            return;
        }
        this.removeMarker(name, set);
        this.addMarker(name, displayName, type, owner, set, location);
    }

    @Override
    public void updateIcon(@NotNull String id, @NotNull MapAssetManager.IconType type, @Nullable UUID owner) {
        MarkerSet set = type == MapAssetManager.IconType.SPAWN ? this.spawnsMarker : (type == MapAssetManager.IconType.HOME ? this.homesMarker : this.warpsMarker);
        String name = "advancedteleport_" + type.name().toLowerCase() + "_" + (String)(type == MapAssetManager.IconType.HOME ? String.valueOf(owner) + "_" + id : id);
        if (set == null) {
            return;
        }
        Marker marker = set.findMarker(name);
        if (marker == null) {
            return;
        }
        this.removeMarker(name, set);
        MapAssetManager.getIcon(id, type, owner).thenAcceptAsync(iconData -> {
            if (iconData == null) {
                return;
            }
            if (!iconData.shown()) {
                return;
            }
            set.createMarker(name, iconData.hoverTooltip().replace("{name}", id), marker.getWorld(), marker.getX(), marker.getY(), marker.getZ(), this.icons.get(iconData.imageKey()), false);
        }, CoreClass.sync);
    }

    @NotNull
    private MarkerSet getSet(@NotNull String id, @NotNull String label) {
        MarkerSet set = this.markerAPI.getMarkerSet(id);
        if (set == null) {
            set = this.markerAPI.createMarkerSet(id, label, null, false);
        }
        return set;
    }
}

