/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks.maps;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.hooks.MapPlugin;
import io.github.niestrat99.advancedteleport.managers.MapAssetManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.LayerProvider;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public final class SquaremapHook
extends MapPlugin<Plugin, Squaremap> {
    private Squaremap provider;

    public SquaremapHook() {
        super("squaremap", Squaremap.class);
    }

    @Override
    @Contract(pure=true)
    public void enable() {
        CoreClass.getInstance().getLogger().info("Found squaremap, hooking...");
        this.provider().ifPresent(squaremap -> {
            this.provider = squaremap;
            for (World world : Bukkit.getWorlds()) {
                this.provider.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
                    Key key = Key.of((String)"advancedteleport_warps");
                    mapWorld.layerRegistry().register(key, (Object)this.createLayerProvider(MainConfig.get().MAP_WARPS));
                    CoreClass.getInstance().getLogger().info("Added the warp layer for " + world.getName() + ".");
                    Key homesKey = Key.of((String)"advancedteleport_homes");
                    mapWorld.layerRegistry().register(homesKey, (Object)this.createLayerProvider(MainConfig.get().MAP_HOMES));
                    CoreClass.getInstance().getLogger().info("Added the homes layer for " + world.getName() + ".");
                    Key spawnsKey = Key.of((String)"advancedteleport_spawns");
                    mapWorld.layerRegistry().register(spawnsKey, (Object)this.createLayerProvider(MainConfig.get().MAP_SPAWNS));
                    CoreClass.getInstance().getLogger().info("Added the spawns layer for " + world.getName() + ".");
                });
            }
        });
    }

    @Override
    @Contract(pure=true)
    public void registerImage(@NotNull String key, @NotNull InputStream stream) {
        try {
            BufferedImage image = ImageIO.read(stream);
            this.provider.iconRegistry().register(Key.of((String)("advancedteleport_" + key)), (Object)image);
        }
        catch (IllegalArgumentException ex) {
            CoreClass.getInstance().getLogger().warning(ex.getMessage());
        }
        catch (IOException e) {
            CoreClass.getInstance().getLogger().warning("Failed to read image for key " + key + "!");
        }
    }

    @Override
    public void addWarp(@NotNull Warp warp) {
        this.addMarker(warp.getName(), MapAssetManager.IconType.WARP, warp.getLocation(), null);
    }

    @Override
    public void addHome(@NotNull Home home) {
        this.addMarker(home.getName() + String.valueOf(home.getOwner()), MapAssetManager.IconType.HOME, home.getLocation(), home.getOwner());
    }

    @Override
    public void addSpawn(@NotNull Spawn spawn) {
        this.addMarker(spawn.getName(), MapAssetManager.IconType.SPAWN, spawn.getLocation(), null);
    }

    @Override
    public void removeWarp(@NotNull Warp warp) {
        this.removeMarker(warp.getName(), MapAssetManager.IconType.WARP, warp.getLocation().getWorld());
    }

    @Override
    public void removeHome(@NotNull Home home) {
        this.removeMarker(home.getName() + String.valueOf(home.getOwner()), MapAssetManager.IconType.HOME, home.getLocation().getWorld());
    }

    @Override
    public void removeSpawn(@NotNull Spawn spawn) {
        this.removeMarker(spawn.getName(), MapAssetManager.IconType.SPAWN, spawn.getLocation().getWorld());
    }

    @Override
    public void moveWarp(@NotNull Warp warp) {
        this.moveMarker(warp.getName(), MapAssetManager.IconType.WARP, warp.getLocation(), null);
    }

    @Override
    public void moveHome(@NotNull Home home) {
        this.moveMarker(home.getName(), MapAssetManager.IconType.HOME, home.getLocation(), home.getOwner());
    }

    @Override
    public void moveSpawn(@NotNull Spawn spawn) {
        this.moveMarker(spawn.getName(), MapAssetManager.IconType.SPAWN, spawn.getLocation(), null);
    }

    private void addMarker(@NotNull String name, @NotNull MapAssetManager.IconType type, @NotNull Location location, @Nullable UUID owner) {
        World world = location.getWorld();
        Objects.requireNonNull(world, "The world for " + name + " is not loaded.");
        this.provider.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
            Key layerKey = Key.of((String)("advancedteleport_" + type.name().toLowerCase() + "s"));
            SimpleLayerProvider layer = (SimpleLayerProvider)mapWorld.layerRegistry().get(layerKey);
            Key key = Key.of((String)("advancedteleport_" + type.name().toLowerCase() + "_" + name));
            Point point = Point.of((double)location.getX(), (double)location.getZ());
            MapAssetManager.getIcon(name, type, owner).thenAcceptAsync(iconData -> {
                if (iconData == null) {
                    return;
                }
                if (!iconData.shown()) {
                    return;
                }
                String imageKey = "advancedteleport_" + iconData.imageKey();
                if (!this.provider.iconRegistry().hasEntry(Key.of((String)imageKey))) {
                    CoreClass.getInstance().getLogger().severe("Key " + imageKey + " is not registered.");
                }
                Icon icon = Icon.icon((Point)point, (Key)Key.of((String)imageKey), (int)iconData.size());
                MarkerOptions.Builder options = icon.markerOptions().asBuilder();
                options.clickTooltip(iconData.clickTooltip().replace("{name}", name));
                options.hoverTooltip(iconData.hoverTooltip().replace("{name}", name));
                icon.markerOptions(options);
                layer.addMarker(key, (Marker)icon);
                CoreClass.getInstance().getLogger().info("Added the " + String.valueOf(location) + " for " + name + ".");
            }, CoreClass.sync);
        });
    }

    private void removeMarker(@NotNull String name, @NotNull MapAssetManager.IconType type, @NotNull World world) {
        Objects.requireNonNull(world, "The world for " + name + " is not loaded.");
        this.provider.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
            Key layerKey = Key.of((String)("advancedteleport_" + type.name().toLowerCase() + "s"));
            SimpleLayerProvider layer = (SimpleLayerProvider)mapWorld.layerRegistry().get(layerKey);
            Key key = Key.of((String)("advancedteleport_" + type.name().toLowerCase() + "_" + name));
            layer.removeMarker(key);
        });
    }

    private void moveMarker(@NotNull String name, @NotNull MapAssetManager.IconType type, @NotNull Location location, @Nullable UUID owner) {
        this.removeMarker(name, type, location.getWorld());
        this.addMarker(name, type, location, owner);
    }

    @Override
    public void updateIcon(@NotNull String id, @NotNull MapAssetManager.IconType type, @Nullable UUID owner) {
        for (World world : Bukkit.getWorlds()) {
            this.provider.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
                Key layerKey = Key.of((String)("advancedteleport_" + type.name().toLowerCase() + "s"));
                SimpleLayerProvider layer = (SimpleLayerProvider)mapWorld.layerRegistry().get(layerKey);
                Key key = Key.of((String)("advancedteleport_" + type.name().toLowerCase() + "_" + id));
                Marker marker = (Marker)layer.registeredMarkers().get(key);
                Point point = null;
                if (!(marker instanceof Icon)) {
                    switch (type) {
                        case WARP: {
                            Warp warp = AdvancedTeleportAPI.getWarp(id);
                            if (warp == null) {
                                return;
                            }
                            point = Point.point((double)warp.getLocation().getX(), (double)warp.getLocation().getZ());
                            break;
                        }
                        case SPAWN: {
                            Spawn spawn = AdvancedTeleportAPI.getSpawn(id);
                            if (spawn == null) {
                                return;
                            }
                            point = Point.point((double)spawn.getLocation().getX(), (double)spawn.getLocation().getZ());
                            break;
                        }
                        case HOME: {
                            if (owner == null) {
                                return;
                            }
                            ATPlayer player = ATPlayer.getPlayer(Bukkit.getOfflinePlayer((UUID)owner));
                            Home home = player.getHome(id);
                            if (home == null) {
                                return;
                            }
                            point = Point.point((double)home.getLocation().getX(), (double)home.getLocation().getZ());
                        }
                    }
                    if (point == null) {
                        return;
                    }
                } else {
                    Icon icon = (Icon)marker;
                    point = icon.point();
                }
                Point finalPoint = point;
                MapAssetManager.getIcon(id, type, owner).thenAcceptAsync(iconData -> {
                    if (iconData == null) {
                        return;
                    }
                    if (!iconData.shown()) {
                        layer.removeMarker(key);
                        return;
                    }
                    String imageKey = "advancedteleport_" + iconData.imageKey();
                    if (!this.provider.iconRegistry().hasEntry(Key.of((String)imageKey))) {
                        CoreClass.getInstance().getLogger().severe("Key " + imageKey + " is not registered.");
                    }
                    Icon newIcon = Icon.icon((Point)finalPoint, (Key)Key.of((String)imageKey), (int)iconData.size());
                    MarkerOptions.Builder options = newIcon.markerOptions().asBuilder();
                    options.clickTooltip(iconData.clickTooltip().replace("{name}", id));
                    options.hoverTooltip(iconData.hoverTooltip().replace("{name}", id));
                    newIcon.markerOptions(options);
                    layer.removeMarker(key);
                    layer.addMarker(key, (Marker)newIcon);
                }, CoreClass.sync);
            });
        }
    }

    @NotNull
    private LayerProvider createLayerProvider(@NotNull MainConfig.MapOptions options) {
        return SimpleLayerProvider.builder((String)options.getLayerName()).showControls(true).defaultHidden(!options.isShownByDefault()).build();
    }
}

