/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks.particles;

import dev.esophose.playerparticles.PlayerParticles;
import dev.esophose.playerparticles.api.PlayerParticlesAPI;
import dev.esophose.playerparticles.particles.PPlayer;
import dev.esophose.playerparticles.particles.ParticleEffect;
import dev.esophose.playerparticles.particles.ParticlePair;
import dev.esophose.playerparticles.particles.data.ColorTransition;
import dev.esophose.playerparticles.particles.data.NoteColor;
import dev.esophose.playerparticles.particles.data.OrdinaryColor;
import dev.esophose.playerparticles.particles.data.Vibration;
import dev.esophose.playerparticles.styles.ParticleStyle;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.hooks.ParticlesPlugin;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayerParticlesHook
extends ParticlesPlugin<PlayerParticles, Void> {
    private PlayerParticlesAPI api;

    public PlayerParticlesHook() {
        super("PlayerParticles");
    }

    @Override
    public boolean pluginUsable() {
        if (!super.pluginUsable()) {
            return false;
        }
        return this.plugin().map(plugin -> {
            this.api = PlayerParticlesAPI.getInstance();
            return true;
        }).orElse(false);
    }

    @Override
    public void applyParticles(@NotNull Player player, @NotNull String command) {
        this.getPairStream(player, command).forEach(pair -> this.api.addActivePlayerParticle(player, pair));
    }

    @Override
    public void removeParticles(@NotNull Player player, @NotNull String command) {
        String[] rawPairs;
        String rawParticle = MainConfig.get().WAITING_PARTICLES.valueOf(command).get();
        if (rawParticle.isEmpty()) {
            return;
        }
        for (String rawPair : rawPairs = rawParticle.split(";")) {
            String[] parts = rawPair.split(",");
            int id = -1;
            for (ParticlePair newPair : this.api.getActivePlayerParticles(player)) {
                if (newPair == null || !newPair.getEffect().getInternalName().equals(parts[0]) || !newPair.getStyle().getInternalName().equals(parts[1]) || !this.getRawDataFromPair(newPair).equals(parts[2])) continue;
                id = newPair.getId();
                break;
            }
            if (id == -1) continue;
            this.api.removeActivePlayerParticle(player, id);
        }
    }

    @Override
    @Nullable
    public String getParticle(@NotNull Player player) {
        Collection particlePairs = this.api.getActivePlayerParticles(player);
        ArrayList<CallSite> particleRawList = new ArrayList<CallSite>();
        for (ParticlePair pair : particlePairs) {
            ParticleEffect effect = pair.getEffect();
            ParticleStyle style = pair.getStyle();
            particleRawList.add((CallSite)((Object)(effect.getInternalName() + "," + style.getInternalName() + "," + this.getRawDataFromPair(pair))));
        }
        if (particleRawList.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)";", particleRawList);
    }

    private String getRawDataFromPair(@NotNull ParticlePair pair) {
        if (pair.getEffect() == ParticleEffect.BLOCK || pair.getEffect() == ParticleEffect.FALLING_DUST) {
            return pair.getBlockMaterial().name();
        }
        if (pair.getEffect() == ParticleEffect.ITEM) {
            return pair.getItemMaterial().name();
        }
        if (pair.getEffect().getDataType().equals((Object)ParticleEffect.ParticleDataType.COLORABLE)) {
            if (pair.getEffect() == ParticleEffect.NOTE) {
                return this.parseColour(pair.getNoteColor(), NoteColor.RAINBOW, NoteColor.RANDOM, String.valueOf(pair.getNoteColor().getNote()));
            }
            return this.parseColour(pair.getColor(), OrdinaryColor.RAINBOW, OrdinaryColor.RANDOM, pair.getColor().getRed() + " " + pair.getColor().getGreen() + " " + pair.getColor().getBlue());
        }
        if (pair.getEffect().getDataType().equals((Object)ParticleEffect.ParticleDataType.COLORABLE_TRANSITION)) {
            String start = this.parseColour(pair.getColorTransition().getStartColor(), OrdinaryColor.RAINBOW, OrdinaryColor.RANDOM, pair.getColor().getRed() + " " + pair.getColor().getGreen() + " " + pair.getColor().getBlue());
            String end = this.parseColour(pair.getColorTransition().getEndColor(), OrdinaryColor.RAINBOW, OrdinaryColor.RANDOM, pair.getColor().getRed() + " " + pair.getColor().getGreen() + " " + pair.getColor().getBlue());
            return start + ">" + end;
        }
        if (pair.getEffect().getDataType().equals((Object)ParticleEffect.ParticleDataType.VIBRATION)) {
            return String.valueOf(pair.getVibration().getDuration());
        }
        return "null";
    }

    @Nullable
    private ParticlePair getPairFromData(@NotNull Player player, @NotNull String data) {
        String[] parts = data.split(",");
        ParticleEffect effect = ParticleEffect.fromInternalName((String)parts[0]);
        if (effect == null) {
            return null;
        }
        ParticleStyle style = ParticleStyle.fromInternalName((String)parts[1]);
        if (style == null) {
            return null;
        }
        String[] rgb = parts[2].split(" ");
        Material itemMaterial = this.get(effect == ParticleEffect.ITEM, () -> Material.getMaterial((String)data));
        Material blockMaterial = this.get(effect == ParticleEffect.BLOCK || effect == ParticleEffect.FALLING_DUST, () -> Material.getMaterial((String)data));
        OrdinaryColor ordinaryColor = this.getNote(parts[2], effect, OrdinaryColor.RAINBOW, OrdinaryColor.RANDOM, () -> new OrdinaryColor(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2])));
        NoteColor noteColor = this.getNote(parts[2], effect, NoteColor.RAINBOW, NoteColor.RANDOM, () -> new NoteColor(Integer.parseInt(rgb[0])));
        Vibration vibration = this.get(effect.getDataType().equals((Object)ParticleEffect.ParticleDataType.VIBRATION), () -> new Vibration(Integer.parseInt(data)));
        ColorTransition colorTransition = this.get(effect.getDataType().equals((Object)ParticleEffect.ParticleDataType.COLORABLE_TRANSITION), () -> {
            String[] startAndEnd = data.split(">");
            String[] startRaw = startAndEnd[0].split(" ");
            String[] endRaw = startAndEnd[1].split(" ");
            OrdinaryColor start = new OrdinaryColor(Integer.parseInt(startRaw[0]), Integer.parseInt(startRaw[1]), Integer.parseInt(startRaw[2]));
            OrdinaryColor end = new OrdinaryColor(Integer.parseInt(endRaw[0]), Integer.parseInt(endRaw[1]), Integer.parseInt(endRaw[2]));
            return new ColorTransition(start, end);
        });
        PPlayer pPlayer = this.api.getPPlayer(player);
        if (pPlayer == null) {
            return null;
        }
        return new ParticlePair(player.getUniqueId(), pPlayer.getNextActiveParticleId(), effect, style, itemMaterial, blockMaterial, ordinaryColor, noteColor, colorTransition, vibration);
    }

    @Nullable
    private <T> T get(boolean condition, @NotNull Supplier<T> supplier) {
        if (condition) {
            return supplier.get();
        }
        return null;
    }

    private <T> T getNote(@NotNull String data, @NotNull ParticleEffect effect, @NotNull T rainbow, @NotNull T random, @NotNull Supplier<T> base) {
        return (T)this.get(effect.getDataType().equals((Object)ParticleEffect.ParticleDataType.COLORABLE), () -> data.equals("rainbow") ? rainbow : (data.equals("random") ? random : base.get()));
    }

    @NotNull
    private <T> String parseColour(@NotNull T colour, @NotNull T rainbow, @NotNull T random, @NotNull String base) {
        if (colour == rainbow) {
            return "rainbow";
        }
        if (colour == random) {
            return "random";
        }
        return base;
    }

    @NotNull
    private Stream<ParticlePair> getPairStream(@NotNull Player player, @NotNull String command) {
        String rawParticle = MainConfig.get().WAITING_PARTICLES.valueOf(command).get();
        if (rawParticle.isEmpty()) {
            return Stream.empty();
        }
        return Arrays.stream(rawParticle.split(";")).map(rawPair -> this.getPairFromData(player, (String)rawPair)).filter(Objects::nonNull);
    }
}

