/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.app.builder;

import io.github.niestrat99.advancedteleport.libs.slimjar.app.AppendingApplication;
import io.github.niestrat99.advancedteleport.libs.slimjar.app.Application;
import io.github.niestrat99.advancedteleport.libs.slimjar.app.builder.ApplicationBuilder;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.DependencyInjector;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.Injectable;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.InjectableFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.ResolutionResult;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.DependencyData;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.resolution.PreResolutionDataProvider;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public final class InjectingApplicationBuilder
extends ApplicationBuilder {
    private final Function<ApplicationBuilder, Injectable> injectableSupplier;

    public InjectingApplicationBuilder(String applicationName, Injectable injectable) {
        this(applicationName, (ApplicationBuilder it) -> injectable);
    }

    public InjectingApplicationBuilder(String applicationName, Function<ApplicationBuilder, Injectable> injectableSupplier) {
        super(applicationName);
        this.injectableSupplier = injectableSupplier;
    }

    @Override
    public Application buildApplication() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException, InterruptedException {
        DependencyDataProvider dataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData dependencyData = dataProvider.get();
        DependencyInjector dependencyInjector = this.createInjector();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> preResolutionResultMap = preResolutionDataProvider.get();
        dependencyInjector.inject(this.injectableSupplier.apply(this), dependencyData, preResolutionResultMap);
        return new AppendingApplication();
    }

    public static ApplicationBuilder createAppending(String applicationName) {
        ClassLoader classLoader = ApplicationBuilder.class.getClassLoader();
        return InjectingApplicationBuilder.createAppending(applicationName, classLoader);
    }

    public static ApplicationBuilder createAppending(String applicationName, ClassLoader classLoader) {
        return new InjectingApplicationBuilder(applicationName, builder -> {
            try {
                return InjectableFactory.create(builder.getDownloadDirectoryPath(), Collections.singleton(Repository.central()), classLoader);
            }
            catch (IOException | InterruptedException | ReflectiveOperationException | URISyntaxException | NoSuchAlgorithmException exception) {
                exception.printStackTrace();
                return null;
            }
        });
    }
}

