/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.downloader;

import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.DependencyDownloader;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.output.OutputWriter;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.output.OutputWriterFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.verify.DependencyVerifier;
import io.github.niestrat99.advancedteleport.libs.slimjar.logging.LogDispatcher;
import io.github.niestrat99.advancedteleport.libs.slimjar.logging.ProcessLogger;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.DependencyResolver;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.ResolutionResult;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.UnresolvedDependencyException;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import io.github.niestrat99.advancedteleport.libs.slimjar.util.Connections;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;

public final class URLDependencyDownloader
implements DependencyDownloader {
    private static final byte[] BOM_BYTES = "bom-file".getBytes();
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final OutputWriterFactory outputWriterProducer;
    private final DependencyResolver dependencyResolver;
    private final DependencyVerifier verifier;

    public URLDependencyDownloader(OutputWriterFactory outputWriterProducer, DependencyResolver dependencyResolver, DependencyVerifier verifier) {
        this.outputWriterProducer = outputWriterProducer;
        this.dependencyResolver = dependencyResolver;
        this.verifier = verifier;
    }

    @Override
    public File download(Dependency dependency) throws IOException, InterruptedException {
        File expectedOutputFile = this.outputWriterProducer.getStrategy().selectFileFor(dependency);
        if (expectedOutputFile.exists() && expectedOutputFile.length() == (long)BOM_BYTES.length && Arrays.equals(Files.readAllBytes(expectedOutputFile.toPath()), BOM_BYTES)) {
            return null;
        }
        if (this.verifier.verify(expectedOutputFile, dependency)) {
            return expectedOutputFile;
        }
        ResolutionResult result = this.dependencyResolver.resolve(dependency).orElseThrow(() -> new UnresolvedDependencyException(dependency));
        if (result.isAggregator()) {
            expectedOutputFile.getParentFile().mkdirs();
            expectedOutputFile.createNewFile();
            Files.write(expectedOutputFile.toPath(), BOM_BYTES, new OpenOption[0]);
            return null;
        }
        expectedOutputFile.delete();
        File checksumFile = this.verifier.getChecksumFile(dependency);
        if (checksumFile != null) {
            checksumFile.delete();
        }
        LOGGER.log("Downloading %s...", dependency.artifactId());
        URL url = result.getDependencyURL();
        LOGGER.debug("Connecting to %s", url);
        URLConnection connection = Connections.createDownloadConnection(url);
        InputStream inputStream = connection.getInputStream();
        LOGGER.debug("Connection successful! Downloading %s", dependency.artifactId() + "...");
        OutputWriter outputWriter = this.outputWriterProducer.create(dependency);
        LOGGER.debug("%s.Size = %s", dependency.artifactId(), connection.getContentLength());
        File downloadResult = outputWriter.writeFrom(inputStream, connection.getContentLength());
        Connections.tryDisconnect(connection);
        this.verifier.verify(downloadResult, dependency);
        LOGGER.debug("Artifact %s downloaded successfully!", dependency.artifactId());
        LOGGER.log("Downloaded %s successfully!", dependency.artifactId());
        return downloadResult;
    }
}

