/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.downloader.strategy;

import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.strategy.FilePathStrategy;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import java.io.File;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FolderedFilePathStrategy
implements FilePathStrategy {
    private static final Logger LOGGER = Logger.getLogger(FolderedFilePathStrategy.class.getName());
    private static final String DEPENDENCY_FILE_FORMAT = "%s/%s/%s/%s/%3$s-%4$s.jar";
    private final File rootDirectory;

    private FolderedFilePathStrategy(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    @Override
    public File selectFileFor(Dependency dependency) {
        String extendedVersion = Optional.ofNullable(dependency.snapshotId()).map(s -> "-" + s).orElse("");
        String path = String.format(DEPENDENCY_FILE_FORMAT, this.rootDirectory.getPath(), dependency.groupId().replace('.', '/'), dependency.artifactId(), dependency.version() + extendedVersion);
        LOGGER.log(Level.FINEST, "Selected jar file for " + dependency.artifactId() + " at " + path);
        return new File(path);
    }

    public static FilePathStrategy createStrategy(File rootDirectory) throws IllegalArgumentException {
        boolean created;
        if (!rootDirectory.exists() && !(created = rootDirectory.mkdirs())) {
            throw new IllegalArgumentException("Could not create specified directory: " + rootDirectory);
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Expecting a directory for download root! " + rootDirectory);
        }
        return new FolderedFilePathStrategy(rootDirectory);
    }
}

