/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.downloader.verify;

import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.output.OutputWriter;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.output.OutputWriterFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.verify.ChecksumCalculator;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.verify.DependencyVerifier;
import io.github.niestrat99.advancedteleport.libs.slimjar.logging.LogDispatcher;
import io.github.niestrat99.advancedteleport.libs.slimjar.logging.ProcessLogger;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.DependencyResolver;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.ResolutionResult;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import io.github.niestrat99.advancedteleport.libs.slimjar.util.Connections;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Objects;
import java.util.Optional;

public final class ChecksumDependencyVerifier
implements DependencyVerifier {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final DependencyResolver resolver;
    private final OutputWriterFactory outputWriterFactory;
    private final DependencyVerifier fallbackVerifier;
    private final ChecksumCalculator checksumCalculator;

    public ChecksumDependencyVerifier(DependencyResolver resolver, OutputWriterFactory outputWriterFactory, DependencyVerifier fallbackVerifier, ChecksumCalculator checksumCalculator) {
        this.resolver = resolver;
        this.outputWriterFactory = outputWriterFactory;
        this.fallbackVerifier = fallbackVerifier;
        this.checksumCalculator = checksumCalculator;
    }

    @Override
    public boolean verify(File file, Dependency dependency) throws IOException, InterruptedException {
        if (!file.exists()) {
            return false;
        }
        LOGGER.log("Verifying checksum for %s", dependency.artifactId());
        File checksumFile = this.outputWriterFactory.getStrategy().selectFileFor(dependency);
        checksumFile.getParentFile().mkdirs();
        if (!checksumFile.exists() && !this.prepareChecksumFile(checksumFile, dependency)) {
            LOGGER.log("Unable to resolve checksum for %s, falling back to fallbackVerifier!", dependency.artifactId());
            return this.fallbackVerifier.verify(file, dependency);
        }
        if (checksumFile.length() == 0L) {
            LOGGER.log("Required checksum not found for %s, using fallbackVerifier!", dependency.artifactId());
            return this.fallbackVerifier.verify(file, dependency);
        }
        String actualChecksum = this.checksumCalculator.calculate(file);
        String expectedChecksum = new String(Files.readAllBytes(checksumFile.toPath())).trim();
        LOGGER.debug("%s -> Actual checksum: %s;", dependency.artifactId(), actualChecksum);
        LOGGER.debug("%s -> Expected checksum: %s;", dependency.artifactId(), expectedChecksum);
        boolean match = Objects.equals(actualChecksum, expectedChecksum);
        LOGGER.log("Checksum %s for %s", match ? "matched" : "match failed", dependency.artifactId());
        return Objects.equals(actualChecksum, expectedChecksum);
    }

    @Override
    public File getChecksumFile(Dependency dependency) {
        File checksumFile = this.outputWriterFactory.getStrategy().selectFileFor(dependency);
        checksumFile.getParentFile().mkdirs();
        return checksumFile;
    }

    private boolean prepareChecksumFile(File checksumFile, Dependency dependency) throws IOException {
        Optional<ResolutionResult> result = this.resolver.resolve(dependency);
        if (result.isEmpty()) {
            return false;
        }
        URL checkSumUrl = result.get().getChecksumURL();
        LOGGER.log("Resolved checksum URL for %s as %s", dependency.artifactId(), checkSumUrl);
        if (checkSumUrl == null) {
            checksumFile.createNewFile();
            return true;
        }
        URLConnection connection = Connections.createDownloadConnection(checkSumUrl);
        InputStream inputStream = connection.getInputStream();
        OutputWriter outputWriter = this.outputWriterFactory.create(dependency);
        outputWriter.writeFrom(inputStream, connection.getContentLength());
        Connections.tryDisconnect(connection);
        LOGGER.log("Downloaded checksum for %s", dependency.artifactId());
        return true;
    }
}

