/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.injector.agent;

import io.github.niestrat99.advancedteleport.libs.slimjar.app.builder.ApplicationBuilder;
import io.github.niestrat99.advancedteleport.libs.slimjar.app.module.ModuleExtractor;
import io.github.niestrat99.advancedteleport.libs.slimjar.app.module.TemporaryModuleExtractor;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.agent.InstrumentationFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.InstrumentationInjectable;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.IsolatedInjectableClassLoader;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.manifest.JarManifestGenerator;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.JarFileRelocator;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.PassthroughRelocator;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.RelocationRule;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.DependencyData;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import io.github.niestrat99.advancedteleport.libs.slimjar.util.Packages;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.UUID;

public final class ByteBuddyInstrumentationFactory
implements InstrumentationFactory {
    public static final String AGENT_JAR = "loader-agent.isolated-jar";
    private static final String AGENT_PACKAGE = "io#github#slimjar#injector#agent";
    private static final String AGENT_CLASS = "ClassLoaderAgent";
    private static final String BYTE_BUDDY_AGENT_CLASS = "net#bytebuddy#agent#ByteBuddyAgent";
    private final URL agentJarUrl;
    private final ModuleExtractor extractor;
    private final JarRelocatorFacadeFactory relocatorFacadeFactory;

    public ByteBuddyInstrumentationFactory(JarRelocatorFacadeFactory relocatorFacadeFactory) {
        this.relocatorFacadeFactory = relocatorFacadeFactory;
        this.agentJarUrl = InstrumentationInjectable.class.getClassLoader().getResource(AGENT_JAR);
        this.extractor = new TemporaryModuleExtractor();
    }

    public ByteBuddyInstrumentationFactory(URL agentJarUrl, ModuleExtractor extractor, JarRelocatorFacadeFactory relocatorFacadeFactory) {
        this.agentJarUrl = agentJarUrl;
        this.extractor = extractor;
        this.relocatorFacadeFactory = relocatorFacadeFactory;
    }

    @Override
    public Instrumentation create() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException, InterruptedException {
        URL extractedURL = this.extractor.extractModule(this.agentJarUrl, "loader-agent");
        String pattern = ByteBuddyInstrumentationFactory.generatePattern();
        String relocatedAgentClass = String.format("%s.%s", pattern, AGENT_CLASS);
        RelocationRule relocationRule = new RelocationRule(Packages.fix(AGENT_PACKAGE), pattern, Collections.emptySet(), Collections.emptySet());
        JarFileRelocator relocator = new JarFileRelocator(Collections.singleton(relocationRule), this.relocatorFacadeFactory);
        File inputFile = new File(extractedURL.toURI());
        File relocatedFile = File.createTempFile("slimjar-agent", ".jar");
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader();
        relocator.relocate(inputFile, relocatedFile);
        JarManifestGenerator.with(relocatedFile.toURI()).attribute("Manifest-Version", "1.0").attribute("Agent-Class", relocatedAgentClass).generate();
        ApplicationBuilder.injecting("SlimJar-Agent", classLoader).dataProviderFactory(dataUrl -> ByteBuddyInstrumentationFactory::getDependency).relocatorFactory(rules -> new PassthroughRelocator()).relocationHelperFactory(rel -> (dependency, file) -> file).build();
        Class<?> byteBuddyAgentClass = Class.forName(Packages.fix(BYTE_BUDDY_AGENT_CLASS), true, classLoader);
        Method attachMethod = byteBuddyAgentClass.getMethod("attach", File.class, String.class, String.class);
        Class<?> processHandle = Class.forName("java.lang.ProcessHandle");
        Method currentMethod = processHandle.getMethod("current", new Class[0]);
        Method pidMethod = processHandle.getMethod("pid", new Class[0]);
        Object currentProcess = currentMethod.invoke(processHandle, new Object[0]);
        Long processId = (Long)pidMethod.invoke(currentProcess, new Object[0]);
        attachMethod.invoke(null, relocatedFile, String.valueOf(processId), "");
        Class<?> agentClass = Class.forName(relocatedAgentClass, true, ClassLoader.getSystemClassLoader());
        Method instrMethod = agentClass.getMethod("getInstrumentation", new Class[0]);
        return (Instrumentation)instrMethod.invoke(null, new Object[0]);
    }

    private static DependencyData getDependency() throws MalformedURLException {
        Dependency byteBuddy = new Dependency("net.bytebuddy", "byte-buddy-agent", "1.11.0", null, Collections.emptyList());
        Repository centralRepository = new Repository(new URL("https://repo1.maven.org/maven2/"));
        return new DependencyData(Collections.emptySet(), Collections.singleton(centralRepository), Collections.singleton(byteBuddy), Collections.emptyList());
    }

    private static String generatePattern() {
        return String.format("slimjar.%s", UUID.randomUUID());
    }
}

