/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.injector.helper;

import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.DependencyDownloader;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.helper.RelocationHelper;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class InjectionHelper {
    private final Set<Dependency> injectedDependencies;
    private final DependencyDownloader dependencyDownloader;
    private final RelocationHelper relocationHelper;

    public InjectionHelper(DependencyDownloader dependencyDownloader, RelocationHelper relocationHelper, Set<Dependency> injectedDependencies) {
        this.dependencyDownloader = dependencyDownloader;
        this.relocationHelper = relocationHelper;
        this.injectedDependencies = injectedDependencies;
    }

    public InjectionHelper(DependencyDownloader dependencyDownloader, RelocationHelper relocationHelper) {
        this(dependencyDownloader, relocationHelper, new HashSet<Dependency>());
    }

    public File fetch(Dependency dependency) throws IOException, ReflectiveOperationException, InterruptedException {
        File downloaded = this.dependencyDownloader.download(dependency);
        if (downloaded == null) {
            return null;
        }
        this.injectedDependencies.add(dependency);
        return this.relocationHelper.relocate(dependency, downloaded);
    }

    public boolean isInjected(Dependency dependency) {
        return this.injectedDependencies.contains(dependency);
    }
}

