/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.injector.helper;

import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.DependencyDownloader;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.DependencyDownloaderFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.output.DependencyOutputWriterFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.strategy.FilePathStrategy;
import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.verify.DependencyVerifierFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.DependencyInjectorFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.helper.InjectionHelper;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.Relocator;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.RelocatorFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.helper.RelocationHelper;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.helper.RelocationHelperFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.DependencyResolver;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.DependencyResolverFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.ResolutionResult;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.DependencyData;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.mirrors.MirrorSelector;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;

public final class InjectionHelperFactory {
    private final Path downloadDirectoryPath;
    private final RelocatorFactory relocatorFactory;
    private final RelocationHelperFactory relocationHelperFactory;
    private final DependencyResolverFactory resolverFactory;
    private final RepositoryEnquirerFactory enquirerFactory;
    private final DependencyDownloaderFactory downloaderFactory;
    private final DependencyVerifierFactory verifier;
    private final MirrorSelector mirrorSelector;

    public InjectionHelperFactory(Path downloadDirectoryPath, RelocatorFactory relocatorFactory, DependencyDataProviderFactory dataProviderFactory, RelocationHelperFactory relocationHelperFactory, DependencyInjectorFactory injectorFactory, DependencyResolverFactory resolverFactory, RepositoryEnquirerFactory enquirerFactory, DependencyDownloaderFactory downloaderFactory, DependencyVerifierFactory verifier, MirrorSelector mirrorSelector) {
        this.downloadDirectoryPath = downloadDirectoryPath;
        this.relocatorFactory = relocatorFactory;
        this.relocationHelperFactory = relocationHelperFactory;
        this.resolverFactory = resolverFactory;
        this.enquirerFactory = enquirerFactory;
        this.downloaderFactory = downloaderFactory;
        this.verifier = verifier;
        this.mirrorSelector = mirrorSelector;
    }

    public InjectionHelper create(DependencyData data, Map<String, ResolutionResult> preResolvedResults) throws IOException, NoSuchAlgorithmException, URISyntaxException {
        Collection<Repository> repositories = this.mirrorSelector.select(data.repositories(), data.mirrors());
        Relocator relocator = this.relocatorFactory.create(data.relocations());
        RelocationHelper relocationHelper = this.relocationHelperFactory.create(relocator);
        FilePathStrategy filePathStrategy = FilePathStrategy.createDefault(this.downloadDirectoryPath.toFile());
        DependencyOutputWriterFactory outputWriterFactory = new DependencyOutputWriterFactory(filePathStrategy);
        DependencyResolver resolver = this.resolverFactory.create(repositories, preResolvedResults, this.enquirerFactory);
        DependencyDownloader downloader = this.downloaderFactory.create(outputWriterFactory, resolver, this.verifier.create(resolver));
        return new InjectionHelper(downloader, relocationHelper);
    }
}

