/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.relocation.helper;

import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.strategy.FilePathStrategy;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.Relocator;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.helper.RelocationHelper;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.meta.MetaMediator;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.meta.MetaMediatorFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;

public final class VerifyingRelocationHelper
implements RelocationHelper {
    private final FilePathStrategy outputFilePathStrategy;
    private final Relocator relocator;
    private final String selfHash;
    private final MetaMediatorFactory mediatorFactory;

    public VerifyingRelocationHelper(String selfHash, FilePathStrategy outputFilePathStrategy, Relocator relocator, MetaMediatorFactory mediatorFactory) throws URISyntaxException, NoSuchAlgorithmException, IOException {
        this.mediatorFactory = mediatorFactory;
        this.outputFilePathStrategy = outputFilePathStrategy;
        this.relocator = relocator;
        this.selfHash = selfHash;
    }

    @Override
    public File relocate(Dependency dependency, File file) throws IOException, ReflectiveOperationException {
        File relocatedFile = this.outputFilePathStrategy.selectFileFor(dependency);
        MetaMediator metaMediator = this.mediatorFactory.create(relocatedFile.toPath());
        if (relocatedFile.exists()) {
            try {
                String ownerHash = metaMediator.readAttribute("slimjar.owner");
                if (this.selfHash != null && ownerHash != null && this.selfHash.trim().equals(ownerHash.trim())) {
                    return relocatedFile;
                }
            }
            catch (Exception exception) {
                relocatedFile.delete();
            }
        }
        this.relocator.relocate(file, relocatedFile);
        metaMediator.writeAttribute("slimjar.owner", this.selfHash);
        return relocatedFile;
    }
}

